/*
 * Decompiled with CFR 0.152.
 */
package filtered;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.NegativeLiteralSelectionStrategy;
import org.sat4j.minisat.orders.PositiveLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.DimacsReader;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.ModelIterator;

public class Filtered {
    private static double[] cost;
    private static boolean[] used_before;
    private static int[] defects;
    private static int numFeatures;
    private static int numConstraints;
    private static List<List<Integer>> constraints;
    private static Random r;
    private static final int SATtimeout = 1000;
    private static final long iteratorTimeout = 150000L;

    public static void main(String[] args) {
        try {
            long start = System.currentTimeMillis();
            String fm = args[0];
            String augment = fm + ".augment";
            Filtered.loadFM(fm, augment);
            int duration = Integer.parseInt(args[1]);
            HashSet<boolean[]> prods = new HashSet<boolean[]>();
            int evaluations = 0;
            while (System.currentTimeMillis() - start < (long)duration) {
                boolean[] prod = Filtered.randomProduct(fm);
                if (Filtered.numViolatedConstraints(prod) == 0) {
                    prods.add(prod);
                }
                ++evaluations;
            }
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("RunTimeMS: " + elapsed);
            System.out.println("Evaluations: " + evaluations);
            int i = 0;
            for (boolean[] prod : prods) {
                Filtered.printProd(i++, prod);
            }
            for (boolean[] prod : prods) {
                Filtered.printProdEval(prod);
            }
        }
        catch (Exception ex) {
            System.out.println("Usage: java -jar filtered.jar fmDimacs timeMS");
        }
    }

    public static void printProd(int index, boolean[] prod) {
        System.out.print("Conf" + (index + 1) + ": ");
        for (int i = 0; i < prod.length; ++i) {
            boolean b = prod[i];
            if (b) {
                System.out.print("1");
                continue;
            }
            System.out.print("0");
        }
        System.out.println("");
    }

    public static boolean[] randomProduct(String fm) {
        boolean[] prod = new boolean[numFeatures];
        for (int i = 0; i < prod.length; ++i) {
            prod[i] = r.nextBoolean();
        }
        int rand = r.nextInt(3);
        try {
            RandomWalkDecorator order = rand == 0 ? new RandomWalkDecorator(new VarOrderHeap(new NegativeLiteralSelectionStrategy()), 1.0) : (rand == 1 ? new RandomWalkDecorator(new VarOrderHeap(new PositiveLiteralSelectionStrategy()), 1.0) : new RandomWalkDecorator(new VarOrderHeap(new RandomLiteralSelectionStrategy()), 1.0));
            Object dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
            dimacsSolver.setTimeout(1000);
            DimacsReader dr = new DimacsReader((ISolver)dimacsSolver);
            dr.parseInstance(new FileReader(fm));
            ((Solver)dimacsSolver).setOrder(order);
            ModelIterator solverIterator = new ModelIterator((ISolver)dimacsSolver);
            solverIterator.setTimeoutMs(150000L);
            if (solverIterator.isSatisfiable()) {
                int[] i = solverIterator.model();
                for (int j = 0; j < i.length; ++j) {
                    int feat = i[j];
                    int posFeat = feat > 0 ? feat : -feat;
                    prod[posFeat - 1] = feat > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prod;
    }

    public static int numViolatedConstraints(boolean[] b) {
        int s = 0;
        for (List<Integer> constraint : constraints) {
            boolean sat = false;
            for (Integer i : constraint) {
                boolean sign;
                int abs = i < 0 ? -i.intValue() : i;
                if (b[abs - 1] != (sign = i > 0)) continue;
                sat = true;
                break;
            }
            if (sat) continue;
            ++s;
        }
        return s;
    }

    public static void printProdEval(boolean[] prod) throws Exception {
        int unselected = 0;
        int unused = 0;
        int defect = 0;
        double cost_ = 0.0;
        for (int i = 0; i < prod.length; ++i) {
            boolean b = prod[i];
            if (!b) {
                ++unselected;
                continue;
            }
            cost_ += cost[i];
            if (used_before[i]) {
                defect += defects[i];
                continue;
            }
            ++unused;
        }
        System.out.println(Filtered.numViolatedConstraints(prod) + " " + unselected + " " + unused + " " + defect + " " + cost_);
    }

    public static void loadFM(String fm, String augment) throws Exception {
        StringTokenizer st;
        String line;
        BufferedReader in = new BufferedReader(new FileReader(fm));
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("p")) {
                st = new StringTokenizer(line, " ");
                st.nextToken();
                st.nextToken();
                numFeatures = Integer.parseInt(st.nextToken());
                numConstraints = Integer.parseInt(st.nextToken());
                constraints = new ArrayList<List<Integer>>(numConstraints);
            }
            if (line.startsWith("c") || line.startsWith("p") || line.isEmpty()) continue;
            st = new StringTokenizer(line, " ");
            ArrayList<Integer> constraint = new ArrayList<Integer>(st.countTokens() - 1);
            while (st.hasMoreTokens()) {
                int i = Integer.parseInt(st.nextToken());
                if (i == 0) continue;
                constraint.add(i);
            }
            constraints.add(constraint);
        }
        in.close();
        cost = new double[numFeatures];
        used_before = new boolean[numFeatures];
        defects = new int[numFeatures];
        in = new BufferedReader(new FileReader(augment));
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            st = new StringTokenizer(line, " ");
            int featIndex = Integer.parseInt(st.nextToken()) - 1;
            Filtered.cost[featIndex] = Double.parseDouble(st.nextToken());
            Filtered.used_before[featIndex] = Integer.parseInt(st.nextToken()) == 1;
            Filtered.defects[featIndex] = Integer.parseInt(st.nextToken());
        }
        in.close();
    }

    static {
        r = new Random();
    }
}

