/*
 * Decompiled with CFR 0.152.
 */
package randomrichsee;

import java.io.FileReader;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.PositiveLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.DimacsReader;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.ModelIterator;

public class RandomRichSee {
    private static final int SATtimeout = 1000;
    private static final long iteratorTimeout = 150000L;

    public static void main(String[] args) {
        try {
            String fm = args[0];
            RandomWalkDecorator order = new RandomWalkDecorator(new VarOrderHeap(new PositiveLiteralSelectionStrategy()), 1.0);
            Object dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
            dimacsSolver.setTimeout(1000);
            DimacsReader dr = new DimacsReader((ISolver)dimacsSolver);
            dr.parseInstance(new FileReader(fm));
            ((Solver)dimacsSolver).setOrder(order);
            ModelIterator solverIterator = new ModelIterator((ISolver)dimacsSolver);
            solverIterator.setTimeoutMs(150000L);
            if (solverIterator.isSatisfiable()) {
                int[] i = solverIterator.model();
                for (int j = 0; j < i.length; ++j) {
                    System.out.print(i[j] + " ");
                }
                System.out.println("");
            }
        }
        catch (Exception e) {
            System.out.println("java -jar RandomRichSeed.jar fmDimacs");
        }
    }
}

