/*
 * Decompiled with CFR 0.152.
 */
package satibea;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.core.Variable;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.DominanceComparator;

public class IBEATimeLimited
extends Algorithm {
    private int print_time = 0;
    private long maxRunTimeMS;
    public static final int TOURNAMENTS_ROUNDS = 1;
    private List<List<Double>> indicatorValues_;
    private double maxIndicatorValue_;

    public IBEATimeLimited(Problem problem, long maxRunTimeMS) {
        super(problem);
        this.maxRunTimeMS = maxRunTimeMS;
    }

    double calcHypervolumeIndicator(Solution p_ind_a, Solution p_ind_b, int d, double[] maximumValues, double[] minimumValues) {
        double volume = 0.0;
        double rho = 2.0;
        double r = rho * (maximumValues[d - 1] - minimumValues[d - 1]);
        double max = minimumValues[d - 1] + r;
        double a = p_ind_a.getObjective(d - 1);
        double b = p_ind_b == null ? max : p_ind_b.getObjective(d - 1);
        if (d == 1) {
            volume = a < b ? (b - a) / r : 0.0;
        } else if (a < b) {
            volume = this.calcHypervolumeIndicator(p_ind_a, null, d - 1, maximumValues, minimumValues) * (b - a) / r;
            volume += this.calcHypervolumeIndicator(p_ind_a, p_ind_b, d - 1, maximumValues, minimumValues) * (max - b) / r;
        } else {
            volume = this.calcHypervolumeIndicator(p_ind_a, p_ind_b, d - 1, maximumValues, minimumValues) * (max - b) / r;
        }
        return volume;
    }

    public void computeIndicatorValuesHD(SolutionSet solutionSet, double[] maximumValues, double[] minimumValues) {
        this.indicatorValues_ = new ArrayList<List<Double>>();
        this.maxIndicatorValue_ = -1.7976931348623157E308;
        for (int j = 0; j < solutionSet.size(); ++j) {
            SolutionSet A = new SolutionSet(1);
            A.add(solutionSet.get(j));
            ArrayList<Double> aux = new ArrayList<Double>();
            for (int i = 0; i < solutionSet.size(); ++i) {
                SolutionSet B = new SolutionSet(1);
                B.add(solutionSet.get(i));
                int flag = new DominanceComparator().compare(A.get(0), B.get(0));
                double value = 0.0;
                value = flag == -1 ? -this.calcHypervolumeIndicator(A.get(0), B.get(0), this.problem_.getNumberOfObjectives(), maximumValues, minimumValues) : this.calcHypervolumeIndicator(B.get(0), A.get(0), this.problem_.getNumberOfObjectives(), maximumValues, minimumValues);
                if (Math.abs(value) > this.maxIndicatorValue_) {
                    this.maxIndicatorValue_ = Math.abs(value);
                }
                aux.add(value);
            }
            this.indicatorValues_.add(aux);
        }
    }

    public void fitness(SolutionSet solutionSet, int pos) {
        double fitness = 0.0;
        double kappa = 0.05;
        for (int i = 0; i < solutionSet.size(); ++i) {
            if (i == pos) continue;
            fitness += Math.exp(-1.0 * this.indicatorValues_.get(i).get(pos) / this.maxIndicatorValue_ / kappa);
        }
        solutionSet.get(pos).setFitness(fitness);
    }

    public void calculateFitness(SolutionSet solutionSet) {
        int pos;
        double[] maximumValues = new double[this.problem_.getNumberOfObjectives()];
        double[] minimumValues = new double[this.problem_.getNumberOfObjectives()];
        for (int i = 0; i < this.problem_.getNumberOfObjectives(); ++i) {
            maximumValues[i] = -1.7976931348623157E308;
            minimumValues[i] = Double.MAX_VALUE;
        }
        for (pos = 0; pos < solutionSet.size(); ++pos) {
            for (int obj = 0; obj < this.problem_.getNumberOfObjectives(); ++obj) {
                double value = solutionSet.get(pos).getObjective(obj);
                if (value > maximumValues[obj]) {
                    maximumValues[obj] = value;
                }
                if (!(value < minimumValues[obj])) continue;
                minimumValues[obj] = value;
            }
        }
        this.computeIndicatorValuesHD(solutionSet, maximumValues, minimumValues);
        for (pos = 0; pos < solutionSet.size(); ++pos) {
            this.fitness(solutionSet, pos);
        }
    }

    public void removeWorst(SolutionSet solutionSet) {
        int i;
        double worst = solutionSet.get(0).getFitness();
        int worstIndex = 0;
        double kappa = 0.05;
        for (i = 1; i < solutionSet.size(); ++i) {
            if (!(solutionSet.get(i).getFitness() > worst)) continue;
            worst = solutionSet.get(i).getFitness();
            worstIndex = i;
        }
        for (i = 0; i < solutionSet.size(); ++i) {
            if (i == worstIndex) continue;
            double fitness = solutionSet.get(i).getFitness();
            solutionSet.get(i).setFitness(fitness -= Math.exp(-this.indicatorValues_.get(worstIndex).get(i).doubleValue() / this.maxIndicatorValue_ / kappa));
        }
        this.indicatorValues_.remove(worstIndex);
        Iterator<List<Double>> it = this.indicatorValues_.iterator();
        while (it.hasNext()) {
            it.next().remove(worstIndex);
        }
        if (solutionSet.get(worstIndex).getObjective(0) == 0.0) {
            System.out.print("Removed-" + this.print_time + "-: ");
            Variable v = solutionSet.get(worstIndex).getDecisionVariables()[0];
            for (int j = 0; j < solutionSet.get(worstIndex).getNumberOfObjectives(); ++j) {
                System.out.print(solutionSet.get(worstIndex).getObjective(j) + " ");
            }
            System.out.println("");
        }
        solutionSet.remove(worstIndex);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        long elapsed = 0L;
        long last = 0L;
        long start = System.currentTimeMillis();
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int archiveSize = (Integer)this.getInputParameter("archiveSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        SolutionSet solutionSet = new SolutionSet(populationSize);
        SolutionSet archive = new SolutionSet(archiveSize);
        int evaluations = 0;
        for (int i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            this.problem_.evaluateConstraints(newSolution);
            ++evaluations;
            solutionSet.add(newSolution);
        }
        while (elapsed < this.maxRunTimeMS) {
            SolutionSet union = solutionSet.union(archive);
            this.calculateFitness(union);
            archive = union;
            while (archive.size() > populationSize) {
                this.removeWorst(archive);
            }
            SolutionSet offSpringSolutionSet = new SolutionSet(populationSize);
            Solution[] parents = new Solution[2];
            while (offSpringSolutionSet.size() < populationSize) {
                int j = 0;
                do {
                    parents[0] = (Solution)selectionOperator.execute(archive);
                } while (++j < 1);
                int k = 0;
                do {
                    parents[1] = (Solution)selectionOperator.execute(archive);
                } while (++k < 1);
                Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offSpring[0]);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[0]);
                offSpringSolutionSet.add(offSpring[0]);
                ++evaluations;
            }
            solutionSet = offSpringSolutionSet;
            elapsed = System.currentTimeMillis() - start;
        }
        System.out.println("RunTimeMS: " + this.maxRunTimeMS);
        System.out.println("Evaluations: " + evaluations);
        Ranking ranking = new Ranking(archive);
        return ranking.getSubfront(0);
    }
}

