/*
 * Decompiled with CFR 0.152.
 */
package satibea;

import java.io.FileReader;
import java.util.List;
import java.util.Random;
import jmetal.core.Problem;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.variable.Binary;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.NegativeLiteralSelectionStrategy;
import org.sat4j.minisat.orders.PositiveLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.DimacsReader;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.ModelIterator;

public class SATIBEA_BinarySolution
extends BinarySolutionType {
    private String fm;
    private int nFeat;
    private List<Integer> mandatoryFeaturesIndices;
    private List<Integer> deadFeaturesIndices;
    int n = 0;
    private List<Integer> seed;
    private static Random r = new Random();
    private static final int SATtimeout = 1000;
    private static final long iteratorTimeout = 150000L;

    public SATIBEA_BinarySolution(Problem problem, int nFeat, String fm, List<Integer> mandatoryFeaturesIndices, List<Integer> deadFeaturesIndices, List<Integer> seed) {
        super(problem);
        this.fm = fm;
        this.nFeat = nFeat;
        this.mandatoryFeaturesIndices = mandatoryFeaturesIndices;
        this.deadFeaturesIndices = deadFeaturesIndices;
        this.seed = seed;
    }

    public boolean[] randomProduct() {
        boolean[] prod = new boolean[this.nFeat];
        for (int i = 0; i < prod.length; ++i) {
            prod[i] = r.nextBoolean();
        }
        int rand = r.nextInt(3);
        try {
            RandomWalkDecorator order = rand == 0 ? new RandomWalkDecorator(new VarOrderHeap(new NegativeLiteralSelectionStrategy()), 1.0) : (rand == 1 ? new RandomWalkDecorator(new VarOrderHeap(new PositiveLiteralSelectionStrategy()), 1.0) : new RandomWalkDecorator(new VarOrderHeap(new RandomLiteralSelectionStrategy()), 1.0));
            Object dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
            dimacsSolver.setTimeout(1000);
            DimacsReader dr = new DimacsReader((ISolver)dimacsSolver);
            dr.parseInstance(new FileReader(this.fm));
            ((Solver)dimacsSolver).setOrder(order);
            ModelIterator solverIterator = new ModelIterator((ISolver)dimacsSolver);
            solverIterator.setTimeoutMs(150000L);
            if (solverIterator.isSatisfiable()) {
                int[] i = solverIterator.model();
                for (int j = 0; j < i.length; ++j) {
                    int feat = i[j];
                    int posFeat = feat > 0 ? feat : -feat;
                    prod[posFeat - 1] = feat > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prod;
    }

    @Override
    public Variable[] createVariables() {
        Variable[] vars = new Variable[this.problem_.getNumberOfVariables()];
        for (int i = 0; i < vars.length; ++i) {
            Binary bin = new Binary(this.nFeat);
            for (int j = 0; j < bin.getNumberOfBits(); ++j) {
                bin.setIth(j, r.nextBoolean());
            }
            for (Integer f : this.mandatoryFeaturesIndices) {
                bin.setIth(f, true);
            }
            for (Integer f : this.deadFeaturesIndices) {
                bin.setIth(f, false);
            }
            vars[i] = bin;
        }
        return vars;
    }
}

