/*
 * Decompiled with CFR 0.152.
 */
package satibea;

import java.io.FileReader;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.core.Variable;
import jmetal.encodings.variable.Binary;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.NegativeLiteralSelectionStrategy;
import org.sat4j.minisat.orders.PositiveLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.DimacsReader;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.ModelIterator;
import satibea.SATIBEA_Problem;
import satibea.SATIBEA_SettingsIBEA;

public class SATIBEA_Main {
    private static Random r = new Random();
    private static final int SATtimeout = 1000;
    private static final long iteratorTimeout = 150000L;

    public static void main(String[] args) throws Exception {
        try {
            Variable v;
            int i;
            String fm = args[0];
            String augment = fm + ".augment";
            String dead = fm + ".dead";
            String mandatory = fm + ".mandatory";
            String seed = fm + ".richseed";
            SATIBEA_Problem p = new SATIBEA_Problem(fm, augment, mandatory, dead, seed);
            Algorithm a = new SATIBEA_SettingsIBEA(p).configureSATIBEA(Integer.parseInt(args[1]), fm, p.getNumFeatures(), p.getConstraints());
            SolutionSet pop = a.execute();
            for (i = 0; i < pop.size(); ++i) {
                v = pop.get(i).getDecisionVariables()[0];
                System.out.println("Conf" + (i + 1) + ": " + (Binary)v + " ");
            }
            for (i = 0; i < pop.size(); ++i) {
                v = pop.get(i).getDecisionVariables()[0];
                for (int j = 0; j < pop.get(i).getNumberOfObjectives(); ++j) {
                    System.out.print(pop.get(i).getObjective(j) + " ");
                }
                System.out.println("");
            }
        }
        catch (Exception e) {
            System.out.println("Usage: java -jar satibea.jar fmDimacs timeMS\nThe .augment, .dead, .mandatory and .richseed files should be in the same directory as the FM.");
        }
    }

    public static int numViolatedConstraints(Binary b) {
        int s = 0;
        for (List<Integer> constraint : SATIBEA_Problem.constraints) {
            boolean sat = false;
            for (Integer i : constraint) {
                boolean sign;
                int abs = i < 0 ? -i.intValue() : i;
                boolean bl = sign = i > 0;
                if (b.getIth(abs - 1) != sign) continue;
                sat = true;
                break;
            }
            if (sat) continue;
            ++s;
        }
        return s;
    }

    public static int numViolatedConstraints(Binary b, HashSet<Integer> blacklist) {
        int s = 0;
        for (List<Integer> constraint : SATIBEA_Problem.constraints) {
            boolean sat = false;
            for (Integer i : constraint) {
                boolean sign;
                int abs = i < 0 ? -i.intValue() : i;
                boolean bl = sign = i > 0;
                if (b.getIth(abs - 1) == sign) {
                    sat = true;
                    continue;
                }
                blacklist.add(abs);
            }
            if (sat) continue;
            ++s;
        }
        return s;
    }

    public static int numViolatedConstraints(boolean[] b) {
        int s = 0;
        for (List<Integer> constraint : SATIBEA_Problem.constraints) {
            boolean sat = false;
            for (Integer i : constraint) {
                boolean sign;
                int abs = i < 0 ? -i.intValue() : i;
                if (b[abs - 1] != (sign = i > 0)) continue;
                sat = true;
                break;
            }
            if (sat) continue;
            ++s;
        }
        return s;
    }

    public boolean[] randomProduct() {
        boolean[] prod = new boolean[SATIBEA_Problem.numFeatures];
        for (int i = 0; i < prod.length; ++i) {
            prod[i] = r.nextBoolean();
        }
        int rand = r.nextInt(3);
        try {
            RandomWalkDecorator order = rand == 0 ? new RandomWalkDecorator(new VarOrderHeap(new NegativeLiteralSelectionStrategy()), 1.0) : (rand == 1 ? new RandomWalkDecorator(new VarOrderHeap(new PositiveLiteralSelectionStrategy()), 1.0) : new RandomWalkDecorator(new VarOrderHeap(new RandomLiteralSelectionStrategy()), 1.0));
            Object dimacsSolver2 = SolverFactory.instance().createSolverByName("MiniSAT");
            dimacsSolver2.setTimeout(1000);
            DimacsReader dr = new DimacsReader((ISolver)dimacsSolver2);
            dr.parseInstance(new FileReader(SATIBEA_Problem.fm));
            ((Solver)dimacsSolver2).setOrder(order);
            ModelIterator solverIterator = new ModelIterator((ISolver)dimacsSolver2);
            solverIterator.setTimeoutMs(150000L);
            if (solverIterator.isSatisfiable()) {
                int[] i = solverIterator.findModel();
                for (int j = 0; j < i.length; ++j) {
                    int posFeat;
                    int feat = i[j];
                    int n = posFeat = feat > 0 ? feat : -feat;
                    if (posFeat <= 0) continue;
                    prod[posFeat - 1] = feat > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return prod;
    }

    public static boolean[] randomProductAssume(IVecInt ivi) {
        boolean[] prod = new boolean[SATIBEA_Problem.numFeatures];
        for (int i = 0; i < prod.length; ++i) {
            prod[i] = r.nextBoolean();
        }
        int rand = r.nextInt(3);
        try {
            RandomWalkDecorator order = rand == 0 ? new RandomWalkDecorator(new VarOrderHeap(new NegativeLiteralSelectionStrategy()), 1.0) : (rand == 1 ? new RandomWalkDecorator(new VarOrderHeap(new PositiveLiteralSelectionStrategy()), 1.0) : new RandomWalkDecorator(new VarOrderHeap(new RandomLiteralSelectionStrategy()), 1.0));
            Object dimacsSolver2 = SolverFactory.instance().createSolverByName("MiniSAT");
            dimacsSolver2.setTimeout(1000);
            DimacsReader dr = new DimacsReader((ISolver)dimacsSolver2);
            dr.parseInstance(new FileReader(SATIBEA_Problem.fm));
            ((Solver)dimacsSolver2).setOrder(order);
            ModelIterator solverIterator = new ModelIterator((ISolver)dimacsSolver2);
            solverIterator.setTimeoutMs(150000L);
            if (solverIterator.isSatisfiable()) {
                int[] i = solverIterator.findModel(ivi);
                for (int j = 0; j < i.length; ++j) {
                    int posFeat;
                    int feat = i[j];
                    int n = posFeat = feat > 0 ? feat : -feat;
                    if (posFeat <= 0) continue;
                    prod[posFeat - 1] = feat > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return prod;
    }
}

