/*
 * Decompiled with CFR 0.152.
 */
package satibea;

import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.solutionType.IntSolutionType;
import jmetal.encodings.variable.Binary;
import jmetal.operators.mutation.Mutation;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.NegativeLiteralSelectionStrategy;
import org.sat4j.minisat.orders.PositiveLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.DimacsReader;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.ModelIterator;
import satibea.SATIBEA_BinarySolution;
import satibea.SATIBEA_Problem;

public class SATIBEA_NewMutation
extends Mutation {
    private static Random r = new Random();
    private String fm;
    private int nFeat;
    private List<List<Integer>> constraints;
    private static final List VALID_TYPES = Arrays.asList(BinarySolutionType.class, BinaryRealSolutionType.class, IntSolutionType.class, SATIBEA_BinarySolution.class);
    private Double mutationProbability_ = null;
    private static final int SATtimeout = 1000;
    private static final long iteratorTimeout = 150000L;

    public SATIBEA_NewMutation(HashMap<String, Object> parameters, String fm, int nFeat, List<List<Integer>> constraints) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.mutationProbability_ = (Double)parameters.get("probability");
        }
        this.fm = fm;
        this.nFeat = nFeat;
        this.constraints = constraints;
    }

    public void doMutation(double probability, Solution solution) throws JMException {
        Integer in = r.nextInt(50);
        if (in != 0) {
            try {
                if (solution.getType().getClass() == BinarySolutionType.class || solution.getType().getClass() == BinaryRealSolutionType.class || solution.getType().getClass() == SATIBEA_BinarySolution.class) {
                    int i;
                    for (i = 0; i < solution.getDecisionVariables().length; ++i) {
                        for (Integer j : SATIBEA_Problem.featureIndicesAllowedFlip) {
                            if (!(PseudoRandom.randDouble() < probability)) continue;
                            ((Binary)solution.getDecisionVariables()[i]).bits_.flip(j);
                        }
                    }
                    for (i = 0; i < solution.getDecisionVariables().length; ++i) {
                        ((Binary)solution.getDecisionVariables()[i]).decode();
                    }
                }
                for (int i = 0; i < solution.getDecisionVariables().length; ++i) {
                    if (!(PseudoRandom.randDouble() < probability)) continue;
                    int value = PseudoRandom.randInt((int)solution.getDecisionVariables()[i].getLowerBound(), (int)solution.getDecisionVariables()[i].getUpperBound());
                    solution.getDecisionVariables()[i].setValue(value);
                }
            }
            catch (ClassCastException e1) {
                Configuration.logger_.severe("BitFlipMutation.doMutation: ClassCastException error" + e1.getMessage());
                Class<String> cls = String.class;
                String name = cls.getName();
                throw new JMException("Exception in " + name + ".doMutation()");
            }
        } else {
            boolean b = r.nextBoolean();
            if (b) {
                for (int i = 0; i < solution.getDecisionVariables().length; ++i) {
                    boolean[] prod = this.randomProduct();
                    Binary bin = (Binary)solution.getDecisionVariables()[i];
                    for (int j = 0; j < prod.length; ++j) {
                        bin.setIth(j, prod[j]);
                    }
                }
            } else {
                HashSet<Integer> blacklist = new HashSet<Integer>();
                for (int i = 0; i < solution.getDecisionVariables().length; ++i) {
                    Binary bin = (Binary)solution.getDecisionVariables()[i];
                    int violated = this.numViolatedConstraints(bin, blacklist);
                    if (violated <= 0) continue;
                    VecInt iv = new VecInt();
                    for (int j = 0; j < SATIBEA_Problem.numFeatures; ++j) {
                        int feat = j + 1;
                        if (blacklist.contains(feat)) continue;
                        iv.push(bin.bits_.get(j) ? feat : -feat);
                    }
                    boolean[] prod = this.randomProductAssume(iv);
                    for (int j = 0; j < prod.length; ++j) {
                        bin.setIth(j, prod[j]);
                    }
                }
            }
        }
    }

    public int numViolatedConstraints(Binary b) {
        int s = 0;
        for (List<Integer> constraint : this.constraints) {
            boolean sat = false;
            for (Integer i : constraint) {
                boolean sign;
                int abs = i < 0 ? -i.intValue() : i;
                boolean bl = sign = i > 0;
                if (b.getIth(abs - 1) != sign) continue;
                sat = true;
                break;
            }
            if (sat) continue;
            ++s;
        }
        return s;
    }

    public int numViolatedConstraints(Binary b, HashSet<Integer> blacklist) {
        int s = 0;
        for (List<Integer> constraint : this.constraints) {
            boolean sat = false;
            for (Integer i : constraint) {
                boolean sign;
                int abs = i < 0 ? -i.intValue() : i;
                boolean bl = sign = i > 0;
                if (b.getIth(abs - 1) == sign) {
                    sat = true;
                    continue;
                }
                blacklist.add(abs);
            }
            if (sat) continue;
            ++s;
        }
        return s;
    }

    public int numViolatedConstraints(boolean[] b) {
        int s = 0;
        for (List<Integer> constraint : this.constraints) {
            boolean sat = false;
            for (Integer i : constraint) {
                boolean sign;
                int abs = i < 0 ? -i.intValue() : i;
                if (b[abs - 1] != (sign = i > 0)) continue;
                sat = true;
                break;
            }
            if (sat) continue;
            ++s;
        }
        return s;
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution solution = (Solution)object;
        if (!VALID_TYPES.contains(solution.getType().getClass())) {
            Configuration.logger_.severe("BitFlipMutation.execute: the solution is not of the right type. The type should be 'Binary', 'BinaryReal' or 'Int', but " + solution.getType() + " is obtained");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        this.doMutation(this.mutationProbability_, solution);
        return solution;
    }

    public boolean[] randomProduct() {
        boolean[] prod = new boolean[this.nFeat];
        for (int i = 0; i < prod.length; ++i) {
            prod[i] = r.nextBoolean();
        }
        int rand = r.nextInt(3);
        try {
            RandomWalkDecorator order = rand == 0 ? new RandomWalkDecorator(new VarOrderHeap(new NegativeLiteralSelectionStrategy()), 1.0) : (rand == 1 ? new RandomWalkDecorator(new VarOrderHeap(new PositiveLiteralSelectionStrategy()), 1.0) : new RandomWalkDecorator(new VarOrderHeap(new RandomLiteralSelectionStrategy()), 1.0));
            Object dimacsSolver2 = SolverFactory.instance().createSolverByName("MiniSAT");
            dimacsSolver2.setTimeout(1000);
            DimacsReader dr = new DimacsReader((ISolver)dimacsSolver2);
            dr.parseInstance(new FileReader(this.fm));
            ((Solver)dimacsSolver2).setOrder(order);
            ModelIterator solverIterator = new ModelIterator((ISolver)dimacsSolver2);
            solverIterator.setTimeoutMs(150000L);
            if (solverIterator.isSatisfiable()) {
                int[] i = solverIterator.findModel();
                for (int j = 0; j < i.length; ++j) {
                    int posFeat;
                    int feat = i[j];
                    int n = posFeat = feat > 0 ? feat : -feat;
                    if (posFeat <= 0) continue;
                    prod[posFeat - 1] = feat > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return prod;
    }

    public boolean[] randomProductAssume(IVecInt ivi) {
        boolean[] prod = new boolean[this.nFeat];
        for (int i = 0; i < prod.length; ++i) {
            prod[i] = r.nextBoolean();
        }
        int rand = r.nextInt(3);
        try {
            RandomWalkDecorator order = rand == 0 ? new RandomWalkDecorator(new VarOrderHeap(new NegativeLiteralSelectionStrategy()), 1.0) : (rand == 1 ? new RandomWalkDecorator(new VarOrderHeap(new PositiveLiteralSelectionStrategy()), 1.0) : new RandomWalkDecorator(new VarOrderHeap(new RandomLiteralSelectionStrategy()), 1.0));
            Object dimacsSolver2 = SolverFactory.instance().createSolverByName("MiniSAT");
            dimacsSolver2.setTimeout(1000);
            DimacsReader dr = new DimacsReader((ISolver)dimacsSolver2);
            dr.parseInstance(new FileReader(this.fm));
            ((Solver)dimacsSolver2).setOrder(order);
            ModelIterator solverIterator = new ModelIterator((ISolver)dimacsSolver2);
            solverIterator.setTimeoutMs(150000L);
            if (solverIterator.isSatisfiable()) {
                int[] i = solverIterator.findModel(ivi);
                for (int j = 0; j < i.length; ++j) {
                    int posFeat;
                    int feat = i[j];
                    int n = posFeat = feat > 0 ? feat : -feat;
                    if (posFeat <= 0) continue;
                    prod[posFeat - 1] = feat > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return prod;
    }
}

