/*
 * Decompiled with CFR 0.152.
 */
package satibea;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.variable.Binary;
import jmetal.util.JMException;
import satibea.SATIBEA_BinarySolution;

public class SATIBEA_Problem
extends Problem {
    public static String fm;
    private String augment;
    public static int numFeatures;
    private int numConstraints;
    public static List<List<Integer>> constraints;
    private double[] cost;
    private boolean[] used_before;
    private int[] defects;
    private static int n;
    private List<Integer> mandatoryFeaturesIndices;
    private List<Integer> deadFeaturesIndices;
    public static List<Integer> featureIndicesAllowedFlip;
    private List<Integer> seed;
    private static final int N_VARS = 1;
    private static final int N_OBJS = 5;

    public SATIBEA_Problem(String fm, String augment, String mandatory, String dead, String seedfile) throws Exception {
        this.numberOfVariables_ = 1;
        this.numberOfObjectives_ = 5;
        this.numberOfConstraints_ = 0;
        SATIBEA_Problem.fm = fm;
        this.augment = augment;
        this.loadFM(fm, augment);
        this.loadMandatoryDeadFeaturesIndices(mandatory, dead);
        this.loadSeed(seedfile);
        this.solutionType_ = new SATIBEA_BinarySolution(this, numFeatures, fm, this.mandatoryFeaturesIndices, this.deadFeaturesIndices, this.seed);
    }

    public List<List<Integer>> getConstraints() {
        return constraints;
    }

    @Override
    public void evaluate(Solution sltn) throws JMException {
        Variable[] vars = sltn.getDecisionVariables();
        Binary bin = (Binary)vars[0];
        int unselected = 0;
        int unused = 0;
        int defect = 0;
        double cost_ = 0.0;
        for (int i = 0; i < bin.getNumberOfBits(); ++i) {
            boolean b = bin.getIth(i);
            if (!b) {
                ++unselected;
                continue;
            }
            cost_ += this.cost[i];
            if (this.used_before[i]) {
                defect += this.defects[i];
                continue;
            }
            ++unused;
        }
        sltn.setObjective(0, this.numViolatedConstraints(bin));
        sltn.setObjective(1, unselected);
        sltn.setObjective(2, unused);
        sltn.setObjective(3, defect);
        sltn.setObjective(4, cost_);
    }

    public String getFm() {
        return fm;
    }

    public int getNumFeatures() {
        return numFeatures;
    }

    public int numViolatedConstraints(Binary b) {
        int s = 0;
        for (List<Integer> constraint : constraints) {
            boolean sat = false;
            for (Integer i : constraint) {
                boolean sign;
                int abs = i < 0 ? -i.intValue() : i;
                boolean bl = sign = i > 0;
                if (b.getIth(abs - 1) != sign) continue;
                sat = true;
                break;
            }
            if (sat) continue;
            ++s;
        }
        return s;
    }

    public void loadFM(String fm, String augment) throws Exception {
        StringTokenizer st;
        String line;
        BufferedReader in = new BufferedReader(new FileReader(fm));
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("p")) {
                st = new StringTokenizer(line, " ");
                st.nextToken();
                st.nextToken();
                numFeatures = Integer.parseInt(st.nextToken());
                this.numConstraints = Integer.parseInt(st.nextToken());
                constraints = new ArrayList<List<Integer>>(this.numConstraints);
            }
            if (line.startsWith("c") || line.startsWith("p") || line.isEmpty()) continue;
            st = new StringTokenizer(line, " ");
            ArrayList<Integer> constraint = new ArrayList<Integer>(st.countTokens() - 1);
            while (st.hasMoreTokens()) {
                int i = Integer.parseInt(st.nextToken());
                if (i == 0) continue;
                constraint.add(i);
            }
            constraints.add(constraint);
        }
        in.close();
        this.cost = new double[numFeatures];
        this.used_before = new boolean[numFeatures];
        this.defects = new int[numFeatures];
        in = new BufferedReader(new FileReader(augment));
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            st = new StringTokenizer(line, " ");
            int featIndex = Integer.parseInt(st.nextToken()) - 1;
            this.cost[featIndex] = Double.parseDouble(st.nextToken());
            this.used_before[featIndex] = Integer.parseInt(st.nextToken()) == 1;
            this.defects[featIndex] = Integer.parseInt(st.nextToken());
        }
    }

    public void loadMandatoryDeadFeaturesIndices(String mandatory, String dead) throws Exception {
        int i;
        String line;
        this.mandatoryFeaturesIndices = new ArrayList<Integer>(numFeatures);
        this.deadFeaturesIndices = new ArrayList<Integer>(numFeatures);
        featureIndicesAllowedFlip = new ArrayList<Integer>(numFeatures);
        BufferedReader in = new BufferedReader(new FileReader(mandatory));
        while ((line = in.readLine()) != null) {
            if (line.isEmpty()) continue;
            i = Integer.parseInt(line) - 1;
            this.mandatoryFeaturesIndices.add(i);
        }
        in.close();
        in = new BufferedReader(new FileReader(dead));
        while ((line = in.readLine()) != null) {
            if (line.isEmpty()) continue;
            i = Integer.parseInt(line) - 1;
            this.deadFeaturesIndices.add(i);
        }
        in.close();
        for (i = 0; i < numFeatures; ++i) {
            if (this.mandatoryFeaturesIndices.contains(i) || this.deadFeaturesIndices.contains(i)) continue;
            featureIndicesAllowedFlip.add(i);
        }
    }

    public void loadSeed(String seedfile) throws Exception {
        String line;
        this.seed = new ArrayList<Integer>(numFeatures);
        Binary bin = new Binary(numFeatures);
        BufferedReader in = new BufferedReader(new FileReader(seedfile));
        while ((line = in.readLine()) != null) {
            line.trim();
            StringTokenizer st = new StringTokenizer(line, " ");
            while (st.hasMoreElements()) {
                int i = Integer.parseInt(st.nextToken());
                this.seed.add(i);
            }
        }
        in.close();
    }

    static {
        n = 0;
    }
}

