/*
 * Decompiled with CFR 0.152.
 */
package satibea;

import java.util.HashMap;
import java.util.List;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.ibea.IBEA;
import jmetal.operators.selection.BinaryTournament;
import jmetal.util.JMException;
import jmetal.util.comparators.FitnessComparator;
import satibea.IBEATimeLimited;
import satibea.SATIBEA_BitFlipMutation;
import satibea.SATIBEA_NewMutation;
import satibea.SATIBEA_SinglePointCrossover;

public class SATIBEA_SettingsIBEA
extends Settings {
    public int populationSize_;
    public int maxEvaluations_;
    public int archiveSize_;
    public double mutationProbability_;
    public double crossoverProbability_;
    public double crossoverDistributionIndex_;
    public double mutationDistributionIndex_;

    public SATIBEA_SettingsIBEA(Problem p) {
        super(p.getName());
        this.problem_ = p;
    }

    public Algorithm configureASE2013(long maxRunTimeMS) throws JMException {
        this.populationSize_ = 300;
        this.archiveSize_ = 300;
        this.mutationProbability_ = 0.001;
        this.crossoverProbability_ = 0.05;
        IBEATimeLimited algorithm = new IBEATimeLimited(this.problem_, maxRunTimeMS);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", this.crossoverProbability_);
        SATIBEA_SinglePointCrossover crossover = new SATIBEA_SinglePointCrossover(parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        SATIBEA_BitFlipMutation mutation = new SATIBEA_BitFlipMutation(parameters);
        parameters = new HashMap();
        parameters.put("comparator", new FitnessComparator());
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    public Algorithm configureSATIBEA(long maxRunTimeMS, String fm, int numFeat, List<List<Integer>> constr) throws JMException {
        this.populationSize_ = 300;
        this.archiveSize_ = 300;
        this.mutationProbability_ = 0.001;
        this.crossoverProbability_ = 0.05;
        IBEATimeLimited algorithm = new IBEATimeLimited(this.problem_, maxRunTimeMS);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", this.crossoverProbability_);
        SATIBEA_SinglePointCrossover crossover = new SATIBEA_SinglePointCrossover(parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        SATIBEA_NewMutation mutation = new SATIBEA_NewMutation(parameters, fm, numFeat, constr);
        parameters = new HashMap();
        parameters.put("comparator", new FitnessComparator());
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    public Algorithm configureICSE2013(int maxEvaluations_) throws JMException {
        this.populationSize_ = 100;
        this.archiveSize_ = 100;
        this.mutationProbability_ = 0.05;
        this.crossoverProbability_ = 0.9;
        IBEA algorithm = new IBEA(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", maxEvaluations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", this.crossoverProbability_);
        SATIBEA_SinglePointCrossover crossover = new SATIBEA_SinglePointCrossover(parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        SATIBEA_BitFlipMutation mutation = new SATIBEA_BitFlipMutation(parameters);
        parameters = new HashMap();
        parameters.put("comparator", new FitnessComparator());
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    @Override
    public Algorithm configure() throws JMException {
        this.populationSize_ = 100;
        this.maxEvaluations_ = 1000;
        this.archiveSize_ = 100;
        this.mutationProbability_ = 0.05;
        this.crossoverProbability_ = 0.9;
        IBEA algorithm = new IBEA(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", this.crossoverProbability_);
        SATIBEA_SinglePointCrossover crossover = new SATIBEA_SinglePointCrossover(parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        SATIBEA_BitFlipMutation mutation = new SATIBEA_BitFlipMutation(parameters);
        parameters = new HashMap();
        parameters.put("comparator", new FitnessComparator());
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

