/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.sat4j.specs.ISolverService;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeuristicsTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private ISolverService solverService;

    public HeuristicsTracing(String string) {
        this.filename = string;
    }

    @Override
    public void solutionFound(int[] nArray) {
        this.trace();
    }

    @Override
    public void restarting() {
        this.trace();
    }

    private void trace() {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append(".dat").toString()));
            int n = this.solverService.nVars();
            double[] dArray = this.solverService.getVariableHeuristics();
            for (int i = 1; i <= n; ++i) {
                printStream.printf("%g %d\n", new Double(dArray[i]), new Integer(i));
            }
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.solverService = iSolverService;
    }
}

