/*
 * Decompiled with CFR 0.152.
 */
package jmetal.core;

import java.io.Serializable;
import jmetal.core.Solution;
import jmetal.core.SolutionType;
import jmetal.util.JMException;

public abstract class Problem
implements Serializable {
    private static final int DEFAULT_PRECISSION = 16;
    protected int numberOfVariables_;
    protected int numberOfObjectives_;
    protected int numberOfConstraints_;
    protected String problemName_;
    protected SolutionType solutionType_;
    protected double[] lowerLimit_;
    protected double[] upperLimit_;
    private int[] precision_;
    protected int[] length_;

    public Problem() {
        this.solutionType_ = null;
    }

    public Problem(SolutionType solutionType) {
        this.solutionType_ = solutionType;
    }

    public int getNumberOfVariables() {
        return this.numberOfVariables_;
    }

    public void setNumberOfVariables(int numberOfVariables) {
        this.numberOfVariables_ = numberOfVariables;
    }

    public int getNumberOfObjectives() {
        return this.numberOfObjectives_;
    }

    public double getLowerLimit(int i) {
        return this.lowerLimit_[i];
    }

    public double getUpperLimit(int i) {
        return this.upperLimit_[i];
    }

    public abstract void evaluate(Solution var1) throws JMException;

    public int getNumberOfConstraints() {
        return this.numberOfConstraints_;
    }

    public void evaluateConstraints(Solution solution) throws JMException {
    }

    public int getPrecision(int var) {
        return this.precision_[var];
    }

    public int[] getPrecision() {
        return this.precision_;
    }

    public void setPrecision(int[] precision) {
        this.precision_ = precision;
    }

    public int getLength(int var) {
        if (this.length_ == null) {
            return 16;
        }
        return this.length_[var];
    }

    public void setSolutionType(SolutionType type) {
        this.solutionType_ = type;
    }

    public SolutionType getSolutionType() {
        return this.solutionType_;
    }

    public String getName() {
        return this.problemName_;
    }

    public int getNumberOfBits() {
        int result = 0;
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            result += this.getLength(var);
        }
        return result;
    }
}

