/*
 * Decompiled with CFR 0.152.
 */
package jmetal.encodings.variable;

import java.util.BitSet;
import jmetal.core.Variable;
import jmetal.encodings.variable.Binary;
import jmetal.util.JMException;

public class BinaryReal
extends Binary {
    public static final int DEFAULT_PRECISION = 30;
    private double value_;
    private double lowerBound_;
    private double upperBound_;

    public BinaryReal() {
    }

    public BinaryReal(int numberOfBits, double lowerBound, double upperBound) {
        super(numberOfBits);
        this.lowerBound_ = lowerBound;
        this.upperBound_ = upperBound;
        this.decode();
    }

    public BinaryReal(BitSet bits, int nbBits, double lowerBound, double upperBound) {
        super(nbBits);
        this.bits_ = bits;
        this.lowerBound_ = lowerBound;
        this.upperBound_ = upperBound;
        this.decode();
    }

    public BinaryReal(BinaryReal variable) {
        super(variable);
        this.lowerBound_ = variable.lowerBound_;
        this.upperBound_ = variable.upperBound_;
        this.value_ = variable.value_;
    }

    @Override
    public void decode() {
        double value = 0.0;
        for (int i = 0; i < this.numberOfBits_; ++i) {
            if (!this.bits_.get(i)) continue;
            value += Math.pow(2.0, i);
        }
        this.value_ = value * (this.upperBound_ - this.lowerBound_) / (Math.pow(2.0, this.numberOfBits_) - 1.0);
        this.value_ += this.lowerBound_;
    }

    @Override
    public double getValue() {
        return this.value_;
    }

    @Override
    public void setValue(double value) throws JMException {
        if (this.numberOfBits_ <= 24 && this.lowerBound_ >= 0.0) {
            BitSet bitSet;
            if (value <= this.lowerBound_) {
                bitSet = new BitSet(this.numberOfBits_);
                bitSet.clear();
            } else if (value >= this.upperBound_) {
                bitSet = new BitSet(this.numberOfBits_);
                bitSet.set(0, this.numberOfBits_);
            } else {
                bitSet = new BitSet(this.numberOfBits_);
                bitSet.clear();
                int integerToCode = 0;
                double tmp = this.lowerBound_;
                double path = (this.upperBound_ - this.lowerBound_) / (Math.pow(2.0, this.numberOfBits_) - 1.0);
                while (tmp < value) {
                    tmp += path;
                    ++integerToCode;
                }
                int remain = integerToCode;
                for (int i = this.numberOfBits_ - 1; i >= 0; --i) {
                    int ithPowerOf2 = (int)Math.pow(2.0, i);
                    if (ithPowerOf2 <= remain) {
                        bitSet.set(i);
                        remain -= ithPowerOf2;
                        continue;
                    }
                    bitSet.clear(i);
                }
            }
            this.bits_ = bitSet;
            this.decode();
        } else {
            if (this.lowerBound_ < 0.0) {
                throw new JMException("Unsupported lowerbound: " + this.lowerBound_ + " > 0");
            }
            if (this.numberOfBits_ >= 24) {
                throw new JMException("Unsupported bit string length" + this.numberOfBits_ + " is > 24 bits");
            }
        }
    }

    @Override
    public Variable deepCopy() {
        return new BinaryReal(this);
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound_;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound_;
    }

    @Override
    public void setLowerBound(double lowerBound) {
        this.lowerBound_ = lowerBound;
    }

    @Override
    public void setUpperBound(double upperBound) {
        this.upperBound_ = upperBound;
    }

    @Override
    public String toString() {
        return this.value_ + "";
    }
}

