/*
 * Decompiled with CFR 0.152.
 */
package jmetal.encodings.variable;

import jmetal.core.Variable;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class Int
extends Variable {
    private int value_;
    private int lowerBound_;
    private int upperBound_;

    public Int() {
        this.lowerBound_ = Integer.MIN_VALUE;
        this.upperBound_ = Integer.MAX_VALUE;
        this.value_ = 0;
    }

    public Int(int lowerBound, int upperBound) {
        this.lowerBound_ = lowerBound;
        this.upperBound_ = upperBound;
        this.value_ = PseudoRandom.randInt(lowerBound, upperBound);
    }

    public Int(int value, int lowerBound, int upperBound) {
        this.value_ = value;
        this.lowerBound_ = lowerBound;
        this.upperBound_ = upperBound;
    }

    public Int(Variable variable) throws JMException {
        this.lowerBound_ = (int)variable.getLowerBound();
        this.upperBound_ = (int)variable.getUpperBound();
        this.value_ = (int)variable.getValue();
    }

    @Override
    public double getValue() {
        return this.value_;
    }

    @Override
    public void setValue(double value) {
        this.value_ = (int)value;
    }

    @Override
    public Variable deepCopy() {
        try {
            return new Int(this);
        }
        catch (JMException e) {
            Configuration.logger_.severe("Int.deepCopy.execute: JMException");
            return null;
        }
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound_;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound_;
    }

    @Override
    public void setLowerBound(double lowerBound) {
        this.lowerBound_ = (int)lowerBound;
    }

    @Override
    public void setUpperBound(double upperBound) {
        this.upperBound_ = (int)upperBound;
    }

    public String toString() {
        return this.value_ + "";
    }
}

