/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.experiments.util.RBoxplot;
import jmetal.experiments.util.RWilcoxon;
import jmetal.experiments.util.RunExperiment;
import jmetal.experiments.util.Statistics;
import jmetal.qualityIndicator.Epsilon;
import jmetal.qualityIndicator.Hypervolume;
import jmetal.qualityIndicator.InvertedGenerationalDistance;
import jmetal.qualityIndicator.Spread;
import jmetal.qualityIndicator.util.MetricsUtil;
import jmetal.util.JMException;
import jmetal.util.NonDominatedSolutionList;

public abstract class Experiment {
    public String experimentName_ = "noName";
    public String[] algorithmNameList_ = null;
    public String[] problemList_ = null;
    public String[] paretoFrontFile_ = null;
    public String[] indicatorList_ = null;
    public String experimentBaseDirectory_ = "";
    public String latexDirectory_ = "latex";
    public String paretoFrontDirectory_ = "";
    public String outputParetoFrontFile_ = "FUN";
    public String outputParetoSetFile_ = "VAR";
    public int independentRuns_ = 0;
    public Settings[] algorithmSettings_ = null;
    HashMap<String, Object> map_ = new HashMap();
    public HashMap<String, Boolean> indicatorMinimize_ = new HashMap();
    public Properties[] problemsSettings_ = null;
    public String[] frontPath_ = null;
    public boolean finished_;
    public static int algorithmIndex;
    public static int problemIndex;
    public static int irunIndex;

    public Experiment() {
        this.indicatorMinimize_.put("HV", false);
        this.indicatorMinimize_.put("EPSILON", true);
        this.indicatorMinimize_.put("SPREAD", true);
        this.indicatorMinimize_.put("GD", true);
        this.indicatorMinimize_.put("IGD", true);
        problemIndex = 0;
        algorithmIndex = 0;
        irunIndex = 0;
    }

    public void runExperiment(int numberOfThreads) throws JMException, IOException {
        int i;
        System.out.println("Experiment: Name: " + this.experimentName_);
        System.out.println("Experiment: creating " + numberOfThreads + " threads");
        System.out.println("Experiment: Number of algorithms: " + this.algorithmNameList_.length);
        System.out.println("Experiment: Number of problems: " + this.problemList_.length);
        System.out.println("Experiment: runs: " + this.independentRuns_);
        System.out.println("Experiment: Experiment directory: " + this.experimentBaseDirectory_);
        RunExperiment[] p = new RunExperiment[numberOfThreads];
        for (i = 0; i < numberOfThreads; ++i) {
            p[i] = new RunExperiment(this, this.map_, i, numberOfThreads, this.problemList_.length);
            p[i].start();
        }
        try {
            for (i = 0; i < numberOfThreads; ++i) {
                p[i].join();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Experiment.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void runExperiment() throws JMException, IOException {
        this.runExperiment(1);
    }

    public void initExperiment() {
        this.checkExperimentDirectory();
        this.map_.put("experimentName", this.experimentName_);
        this.map_.put("experimentDirectory", this.experimentBaseDirectory_);
        this.map_.put("algorithmNameList", this.algorithmNameList_);
        this.map_.put("problemList", this.problemList_);
        this.map_.put("indicatorList", this.indicatorList_);
        this.map_.put("paretoFrontDirectory", this.paretoFrontDirectory_);
        this.map_.put("paretoFrontFile", this.paretoFrontFile_);
        this.map_.put("independentRuns", this.independentRuns_);
        this.map_.put("outputParetoFrontFile", this.outputParetoFrontFile_);
        this.map_.put("outputParetoSetFile", this.outputParetoSetFile_);
        this.map_.put("problemsSettings", this.problemsSettings_);
        this.frontPath_ = new String[this.problemList_.length];
        this.map_.put("frontPath", this.frontPath_);
    }

    public void runCompleteExperiment() throws JMException, IOException {
        this.runCompleteExperiment(1);
    }

    public void runCompleteExperiment(int numberOfThreads) throws JMException, IOException {
        this.initExperiment();
        this.runExperiment(numberOfThreads);
        this.generateQualityIndicators();
    }

    private void checkExperimentDirectory() {
        File experimentDirectory = new File(this.experimentBaseDirectory_);
        if (experimentDirectory.exists()) {
            System.out.println("Experiment directory exists");
            if (experimentDirectory.isDirectory()) {
                System.out.println("Experiment directory is a directory");
            } else {
                System.out.println("Experiment directory is not a directory. Deleting file and creating directory");
            }
            experimentDirectory.delete();
            new File(this.experimentBaseDirectory_).mkdirs();
        } else {
            System.out.println("Experiment directory does NOT exist. Creating");
            new File(this.experimentBaseDirectory_).mkdirs();
        }
    }

    public abstract void algorithmSettings(String var1, int var2, Algorithm[] var3) throws ClassNotFoundException;

    public static void main(String[] args) throws JMException, IOException {
    }

    private void checkParetoFronts() {
        if (this.paretoFrontDirectory_.equals("") || this.paretoFrontDirectory_ == null) {
            this.generateReferenceFronts();
        } else {
            for (int i = 0; i < this.problemList_.length; ++i) {
                if (this.paretoFrontFile_[i] == null || this.paretoFrontFile_[i].equals("")) {
                    this.paretoFrontFile_[i] = "";
                    this.generateReferenceFronts(i);
                    continue;
                }
                String filePath = this.paretoFrontDirectory_ + "/" + this.paretoFrontFile_[i];
                File f = new File(filePath);
                if (!f.exists()) {
                    this.paretoFrontFile_[i] = "";
                    this.generateReferenceFronts(i);
                    continue;
                }
                this.frontPath_[i] = this.paretoFrontDirectory_ + "/" + this.paretoFrontFile_[i];
            }
        }
    }

    public void generateQualityIndicators() {
        this.checkParetoFronts();
        if (this.indicatorList_.length > 0) {
            for (int algorithmIndex = 0; algorithmIndex < this.algorithmNameList_.length; ++algorithmIndex) {
                String algorithmDirectory = this.experimentBaseDirectory_ + "/data/" + this.algorithmNameList_[algorithmIndex] + "/";
                for (int problemIndex = 0; problemIndex < this.problemList_.length; ++problemIndex) {
                    String problemDirectory = algorithmDirectory + this.problemList_[problemIndex];
                    String paretoFrontPath = this.frontPath_[problemIndex];
                    for (String anIndicatorList_ : this.indicatorList_) {
                        System.out.println("Experiment - Quality indicator: " + anIndicatorList_);
                        this.resetFile(problemDirectory + "/" + anIndicatorList_);
                        for (int numRun = 0; numRun < this.independentRuns_; ++numRun) {
                            double[][] solutionFront;
                            Object indicators;
                            String outputParetoFrontFilePath;
                            String solutionFrontFile = outputParetoFrontFilePath = problemDirectory + "/FUN." + numRun;
                            String qualityIndicatorFile = problemDirectory;
                            double value = 0.0;
                            double[][] trueFront = new Hypervolume().utils_.readFront(paretoFrontPath);
                            if (anIndicatorList_.equals("HV")) {
                                indicators = new Hypervolume();
                                solutionFront = ((Hypervolume)indicators).utils_.readFront(solutionFrontFile);
                                value = ((Hypervolume)indicators).hypervolume(solutionFront, trueFront, trueFront[0].length);
                                qualityIndicatorFile = qualityIndicatorFile + "/HV";
                            }
                            if (anIndicatorList_.equals("SPREAD")) {
                                indicators = new Spread();
                                solutionFront = Spread.utils_.readFront(solutionFrontFile);
                                value = ((Spread)indicators).spread(solutionFront, trueFront, trueFront[0].length);
                                qualityIndicatorFile = qualityIndicatorFile + "/SPREAD";
                            }
                            if (anIndicatorList_.equals("IGD")) {
                                indicators = new InvertedGenerationalDistance();
                                solutionFront = ((InvertedGenerationalDistance)indicators).utils_.readFront(solutionFrontFile);
                                value = ((InvertedGenerationalDistance)indicators).invertedGenerationalDistance(solutionFront, trueFront, trueFront[0].length);
                                qualityIndicatorFile = qualityIndicatorFile + "/IGD";
                            }
                            if (anIndicatorList_.equals("EPSILON")) {
                                indicators = new Epsilon();
                                solutionFront = ((Epsilon)indicators).utils_.readFront(solutionFrontFile);
                                value = ((Epsilon)indicators).epsilon(solutionFront, trueFront, trueFront[0].length);
                                qualityIndicatorFile = qualityIndicatorFile + "/EPSILON";
                            }
                            if (qualityIndicatorFile.equals(problemDirectory)) continue;
                            try {
                                FileWriter os = new FileWriter(qualityIndicatorFile, true);
                                os.write("" + value + "\n");
                                os.close();
                                continue;
                            }
                            catch (IOException ex) {
                                Logger.getLogger(Experiment.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
            }
        }
    }

    private void resetFile(String file) {
        File f = new File(file);
        if (f.exists()) {
            System.out.println("File " + file + " exist.");
            if (f.isDirectory()) {
                System.out.println("File " + file + " is a directory. Deleting directory.");
                if (f.delete()) {
                    System.out.println("Directory successfully deleted.");
                } else {
                    System.out.println("Error deleting directory.");
                }
            } else {
                System.out.println("File " + file + " is a file. Deleting file.");
                if (f.delete()) {
                    System.out.println("File succesfully deleted.");
                } else {
                    System.out.println("Error deleting file.");
                }
            }
        } else {
            System.out.println("File " + file + " does NOT exist.");
        }
    }

    public void generateReferenceFronts(int problemIndex) {
        String referenceFrontDirectory = this.experimentBaseDirectory_ + "/referenceFronts";
        File rfDirectory = new File(referenceFrontDirectory);
        if (!rfDirectory.exists()) {
            boolean result = new File(referenceFrontDirectory).mkdirs();
            System.out.println("Creating " + referenceFrontDirectory);
        }
        this.frontPath_[problemIndex] = referenceFrontDirectory + "/" + this.problemList_[problemIndex] + ".rf";
        MetricsUtil metricsUtils = new MetricsUtil();
        NonDominatedSolutionList solutionSet = new NonDominatedSolutionList();
        for (String anAlgorithmNameList_ : this.algorithmNameList_) {
            String problemDirectory = this.experimentBaseDirectory_ + "/data/" + anAlgorithmNameList_ + "/" + this.problemList_[problemIndex];
            for (int numRun = 0; numRun < this.independentRuns_; ++numRun) {
                String outputParetoFrontFilePath;
                String solutionFrontFile = outputParetoFrontFilePath = problemDirectory + "/FUN." + numRun;
                metricsUtils.readNonDominatedSolutionSet(solutionFrontFile, solutionSet);
            }
        }
        solutionSet.printObjectivesToFile(this.frontPath_[problemIndex]);
    }

    public void generateReferenceFronts() {
        for (int problemIndex = 0; problemIndex < this.problemList_.length; ++problemIndex) {
            this.generateReferenceFronts(problemIndex);
        }
    }

    public void generateLatexTables() throws FileNotFoundException, IOException {
        this.latexDirectory_ = this.experimentBaseDirectory_ + "/" + this.latexDirectory_;
        System.out.println("latex directory: " + this.latexDirectory_);
        Vector[][][] data = new Vector[this.indicatorList_.length][][];
        for (int indicator = 0; indicator < this.indicatorList_.length; ++indicator) {
            data[indicator] = new Vector[this.problemList_.length][];
            for (int problem = 0; problem < this.problemList_.length; ++problem) {
                data[indicator][problem] = new Vector[this.algorithmNameList_.length];
                for (int algorithm = 0; algorithm < this.algorithmNameList_.length; ++algorithm) {
                    data[indicator][problem][algorithm] = new Vector();
                    String directory = this.experimentBaseDirectory_;
                    directory = directory + "/data/";
                    directory = directory + "/" + this.algorithmNameList_[algorithm];
                    directory = directory + "/" + this.problemList_[problem];
                    directory = directory + "/" + this.indicatorList_[indicator];
                    FileInputStream fis = new FileInputStream(directory);
                    InputStreamReader isr = new InputStreamReader(fis);
                    BufferedReader br = new BufferedReader(isr);
                    String aux = br.readLine();
                    while (aux != null) {
                        data[indicator][problem][algorithm].add(Double.parseDouble(aux));
                        aux = br.readLine();
                    }
                }
            }
        }
        HashMap<String, Double> statValues = new HashMap<String, Double>();
        statValues.put("mean", 0.0);
        statValues.put("median", 0.0);
        statValues.put("stdDeviation", 0.0);
        statValues.put("iqr", 0.0);
        statValues.put("max", 0.0);
        statValues.put("min", 0.0);
        double[][][] mean = new double[this.indicatorList_.length][][];
        double[][][] median = new double[this.indicatorList_.length][][];
        double[][][] stdDeviation = new double[this.indicatorList_.length][][];
        double[][][] iqr = new double[this.indicatorList_.length][][];
        double[][][] min = new double[this.indicatorList_.length][][];
        double[][][] max = new double[this.indicatorList_.length][][];
        int[][][] numberOfValues = new int[this.indicatorList_.length][][];
        for (int indicator = 0; indicator < this.indicatorList_.length; ++indicator) {
            mean[indicator] = new double[this.problemList_.length][];
            median[indicator] = new double[this.problemList_.length][];
            stdDeviation[indicator] = new double[this.problemList_.length][];
            iqr[indicator] = new double[this.problemList_.length][];
            min[indicator] = new double[this.problemList_.length][];
            max[indicator] = new double[this.problemList_.length][];
            numberOfValues[indicator] = new int[this.problemList_.length][];
            for (int problem = 0; problem < this.problemList_.length; ++problem) {
                mean[indicator][problem] = new double[this.algorithmNameList_.length];
                median[indicator][problem] = new double[this.algorithmNameList_.length];
                stdDeviation[indicator][problem] = new double[this.algorithmNameList_.length];
                iqr[indicator][problem] = new double[this.algorithmNameList_.length];
                min[indicator][problem] = new double[this.algorithmNameList_.length];
                max[indicator][problem] = new double[this.algorithmNameList_.length];
                numberOfValues[indicator][problem] = new int[this.algorithmNameList_.length];
                for (int algorithm = 0; algorithm < this.algorithmNameList_.length; ++algorithm) {
                    Collections.sort(data[indicator][problem][algorithm]);
                    String directory = this.experimentBaseDirectory_;
                    directory = directory + "/" + this.algorithmNameList_[algorithm];
                    directory = directory + "/" + this.problemList_[problem];
                    directory = directory + "/" + this.indicatorList_[indicator];
                    this.calculateStatistics(data[indicator][problem][algorithm], statValues);
                    mean[indicator][problem][algorithm] = (Double)statValues.get("mean");
                    median[indicator][problem][algorithm] = (Double)statValues.get("median");
                    stdDeviation[indicator][problem][algorithm] = (Double)statValues.get("stdDeviation");
                    iqr[indicator][problem][algorithm] = (Double)statValues.get("iqr");
                    min[indicator][problem][algorithm] = (Double)statValues.get("min");
                    max[indicator][problem][algorithm] = (Double)statValues.get("max");
                    numberOfValues[indicator][problem][algorithm] = data[indicator][problem][algorithm].size();
                }
            }
        }
        File latexOutput = new File(this.latexDirectory_);
        if (!latexOutput.exists()) {
            boolean result = new File(this.latexDirectory_).mkdirs();
            System.out.println("Creating " + this.latexDirectory_ + " directory");
        }
        String latexFile = this.latexDirectory_ + "/" + this.experimentName_ + ".tex";
        this.printHeaderLatexCommands(latexFile);
        for (int i = 0; i < this.indicatorList_.length; ++i) {
            this.printMeanStdDev(latexFile, i, mean, stdDeviation);
            this.printMedianIQR(latexFile, i, median, iqr);
        }
        this.printEndLatexCommands(latexFile);
    }

    void calculateStatistics(Vector vector, Map<String, Double> values) {
        if (vector.size() > 0) {
            double sqsum = 0.0;
            double sum = 0.0;
            double min = 1.0E300;
            double max = -1.0E300;
            double median = 0.0;
            for (int i = 0; i < vector.size(); ++i) {
                double val = (Double)vector.elementAt(i);
                sqsum += val * val;
                sum += val;
                if (val < min) {
                    min = val;
                }
                if (!(val > max)) continue;
                max = val;
            }
            double mean = sum / (double)vector.size();
            double stdDeviation = sqsum / (double)vector.size() - mean * mean < 0.0 ? 0.0 : Math.sqrt(sqsum / (double)vector.size() - mean * mean);
            median = vector.size() % 2 != 0 ? (Double)vector.elementAt(vector.size() / 2) : ((Double)vector.elementAt(vector.size() / 2 - 1) + (Double)vector.elementAt(vector.size() / 2)) / 2.0;
            values.put("mean", mean);
            values.put("median", Statistics.calculateMedian(vector, 0, vector.size() - 1));
            values.put("iqr", Statistics.calculateIQR(vector));
            values.put("stdDeviation", stdDeviation);
            values.put("min", min);
            values.put("max", max);
        } else {
            values.put("mean", Double.NaN);
            values.put("median", Double.NaN);
            values.put("iqr", Double.NaN);
            values.put("stdDeviation", Double.NaN);
            values.put("min", Double.NaN);
            values.put("max", Double.NaN);
        }
    }

    void printHeaderLatexCommands(String fileName) throws IOException {
        FileWriter os = new FileWriter(fileName, false);
        os.write("\\documentclass{article}\n");
        os.write("\\title{" + this.experimentName_ + "}" + "\n");
        os.write("\\usepackage{colortbl}\n");
        os.write("\\usepackage[table*]{xcolor}\n");
        os.write("\\xdefinecolor{gray95}{gray}{0.65}\n");
        os.write("\\xdefinecolor{gray25}{gray}{0.8}\n");
        os.write("\\author{}\n");
        os.write("\\begin{document}\n");
        os.write("\\maketitle\n");
        os.write("\\section{Tables}\n");
        os.close();
    }

    void printEndLatexCommands(String fileName) throws IOException {
        FileWriter os = new FileWriter(fileName, true);
        os.write("\\end{document}\n");
        os.close();
    }

    void printMeanStdDev(String fileName, int indicator, double[][][] mean, double[][][] stdDev) throws IOException {
        FileWriter os = new FileWriter(fileName, true);
        os.write("\\\n");
        os.write("\\begin{table}\n");
        os.write("\\caption{" + this.indicatorList_[indicator] + ". Mean and standard deviation}" + "\n");
        os.write("\\label{table:mean." + this.indicatorList_[indicator] + "}" + "\n");
        os.write("\\centering\n");
        os.write("\\begin{scriptsize}\n");
        os.write("\\begin{tabular}{l");
        for (String anAlgorithmNameList_ : this.algorithmNameList_) {
            os.write("l");
        }
        os.write("}\n");
        os.write("\\hline");
        for (int i = -1; i < this.algorithmNameList_.length; ++i) {
            if (i == -1) {
                os.write(" & ");
                continue;
            }
            if (i == this.algorithmNameList_.length - 1) {
                os.write(" " + this.algorithmNameList_[i] + "\\\\" + "\n");
                continue;
            }
            os.write("" + this.algorithmNameList_[i] + " & ");
        }
        os.write("\\hline\n");
        for (int i = 0; i < this.problemList_.length; ++i) {
            int j;
            double secondBestValueIQR;
            double secondBestValue;
            double bestValueIQR;
            double bestValue;
            int bestIndex = -1;
            int secondBestIndex = -1;
            if (this.indicatorMinimize_.get(this.indicatorList_[indicator]).booleanValue()) {
                bestValue = Double.MAX_VALUE;
                bestValueIQR = Double.MAX_VALUE;
                secondBestValue = Double.MAX_VALUE;
                secondBestValueIQR = Double.MAX_VALUE;
                for (j = 0; j < this.algorithmNameList_.length; ++j) {
                    if (mean[indicator][i][j] < bestValue || mean[indicator][i][j] == bestValue && stdDev[indicator][i][j] < bestValueIQR) {
                        secondBestIndex = bestIndex;
                        secondBestValue = bestValue;
                        secondBestValueIQR = bestValueIQR;
                        bestValue = mean[indicator][i][j];
                        bestValueIQR = stdDev[indicator][i][j];
                        bestIndex = j;
                        continue;
                    }
                    if (!(mean[indicator][i][j] < secondBestValue) && (mean[indicator][i][j] != secondBestValue || !(stdDev[indicator][i][j] < secondBestValueIQR))) continue;
                    secondBestIndex = j;
                    secondBestValue = mean[indicator][i][j];
                    secondBestValueIQR = stdDev[indicator][i][j];
                }
            } else {
                bestValue = Double.MIN_VALUE;
                bestValueIQR = Double.MIN_VALUE;
                secondBestValue = Double.MIN_VALUE;
                secondBestValueIQR = Double.MIN_VALUE;
                for (j = 0; j < this.algorithmNameList_.length; ++j) {
                    if (mean[indicator][i][j] > bestValue || mean[indicator][i][j] == bestValue && stdDev[indicator][i][j] < bestValueIQR) {
                        secondBestIndex = bestIndex;
                        secondBestValue = bestValue;
                        secondBestValueIQR = bestValueIQR;
                        bestValue = mean[indicator][i][j];
                        bestValueIQR = stdDev[indicator][i][j];
                        bestIndex = j;
                        continue;
                    }
                    if (!(mean[indicator][i][j] > secondBestValue) && (mean[indicator][i][j] != secondBestValue || !(stdDev[indicator][i][j] < secondBestValueIQR))) continue;
                    secondBestIndex = j;
                    secondBestValue = mean[indicator][i][j];
                    secondBestValueIQR = stdDev[indicator][i][j];
                }
            }
            os.write(this.problemList_[i].replace("_", "\\_") + " & ");
            for (j = 0; j < this.algorithmNameList_.length - 1; ++j) {
                if (j == bestIndex) {
                    os.write("\\cellcolor{gray95}");
                }
                if (j == secondBestIndex) {
                    os.write("\\cellcolor{gray25}");
                }
                String m = String.format(Locale.ENGLISH, "%10.2e", mean[indicator][i][j]);
                String s = String.format(Locale.ENGLISH, "%8.1e", stdDev[indicator][i][j]);
                os.write("$" + m + "_{" + s + "}$ & ");
            }
            if (bestIndex == this.algorithmNameList_.length - 1) {
                os.write("\\cellcolor{gray95}");
            }
            String m = String.format(Locale.ENGLISH, "%10.2e", mean[indicator][i][this.algorithmNameList_.length - 1]);
            String s = String.format(Locale.ENGLISH, "%8.1e", stdDev[indicator][i][this.algorithmNameList_.length - 1]);
            os.write("$" + m + "_{" + s + "}$ \\\\" + "\n");
        }
        os.write("\\hline\n");
        os.write("\\end{tabular}\n");
        os.write("\\end{scriptsize}\n");
        os.write("\\end{table}\n");
        os.close();
    }

    void printMedianIQR(String fileName, int indicator, double[][][] median, double[][][] IQR) throws IOException {
        FileWriter os = new FileWriter(fileName, true);
        os.write("\\\n");
        os.write("\\begin{table}\n");
        os.write("\\caption{" + this.indicatorList_[indicator] + ". Median and IQR}" + "\n");
        os.write("\\label{table:median." + this.indicatorList_[indicator] + "}" + "\n");
        os.write("\\begin{scriptsize}\n");
        os.write("\\centering\n");
        os.write("\\begin{tabular}{l");
        for (String anAlgorithmNameList_ : this.algorithmNameList_) {
            os.write("l");
        }
        os.write("}\n");
        os.write("\\hline");
        for (int i = -1; i < this.algorithmNameList_.length; ++i) {
            if (i == -1) {
                os.write(" & ");
                continue;
            }
            if (i == this.algorithmNameList_.length - 1) {
                os.write(" " + this.algorithmNameList_[i] + "\\\\" + "\n");
                continue;
            }
            os.write("" + this.algorithmNameList_[i] + " & ");
        }
        os.write("\\hline\n");
        for (int i = 0; i < this.problemList_.length; ++i) {
            int j;
            double secondBestValueIQR;
            double secondBestValue;
            double bestValueIQR;
            double bestValue;
            int bestIndex = -1;
            int secondBestIndex = -1;
            if (this.indicatorMinimize_.get(this.indicatorList_[indicator]).booleanValue()) {
                bestValue = Double.MAX_VALUE;
                bestValueIQR = Double.MAX_VALUE;
                secondBestValue = Double.MAX_VALUE;
                secondBestValueIQR = Double.MAX_VALUE;
                for (j = 0; j < this.algorithmNameList_.length; ++j) {
                    if (median[indicator][i][j] < bestValue || median[indicator][i][j] == bestValue && IQR[indicator][i][j] < bestValueIQR) {
                        secondBestIndex = bestIndex;
                        secondBestValue = bestValue;
                        secondBestValueIQR = bestValueIQR;
                        bestValue = median[indicator][i][j];
                        bestValueIQR = IQR[indicator][i][j];
                        bestIndex = j;
                        continue;
                    }
                    if (!(median[indicator][i][j] < secondBestValue) && (median[indicator][i][j] != secondBestValue || !(IQR[indicator][i][j] < secondBestValueIQR))) continue;
                    secondBestIndex = j;
                    secondBestValue = median[indicator][i][j];
                    secondBestValueIQR = IQR[indicator][i][j];
                }
            } else {
                bestValue = Double.MIN_VALUE;
                bestValueIQR = Double.MIN_VALUE;
                secondBestValue = Double.MIN_VALUE;
                secondBestValueIQR = Double.MIN_VALUE;
                for (j = 0; j < this.algorithmNameList_.length; ++j) {
                    if (median[indicator][i][j] > bestValue || median[indicator][i][j] == bestValue && IQR[indicator][i][j] < bestValueIQR) {
                        secondBestIndex = bestIndex;
                        secondBestValue = bestValue;
                        secondBestValueIQR = bestValueIQR;
                        bestValue = median[indicator][i][j];
                        bestValueIQR = IQR[indicator][i][j];
                        bestIndex = j;
                        continue;
                    }
                    if (!(median[indicator][i][j] > secondBestValue) && (median[indicator][i][j] != secondBestValue || !(IQR[indicator][i][j] < secondBestValueIQR))) continue;
                    secondBestIndex = j;
                    secondBestValue = median[indicator][i][j];
                    secondBestValueIQR = IQR[indicator][i][j];
                }
            }
            os.write(this.problemList_[i].replace("_", "\\_") + " & ");
            for (j = 0; j < this.algorithmNameList_.length - 1; ++j) {
                if (j == bestIndex) {
                    os.write("\\cellcolor{gray95}");
                }
                if (j == secondBestIndex) {
                    os.write("\\cellcolor{gray25}");
                }
                String m = String.format(Locale.ENGLISH, "%10.2e", median[indicator][i][j]);
                String s = String.format(Locale.ENGLISH, "%8.1e", IQR[indicator][i][j]);
                os.write("$" + m + "_{" + s + "}$ & ");
            }
            if (bestIndex == this.algorithmNameList_.length - 1) {
                os.write("\\cellcolor{gray95}");
            }
            String m = String.format(Locale.ENGLISH, "%10.2e", median[indicator][i][this.algorithmNameList_.length - 1]);
            String s = String.format(Locale.ENGLISH, "%8.1e", IQR[indicator][i][this.algorithmNameList_.length - 1]);
            os.write("$" + m + "_{" + s + "}$ \\\\" + "\n");
        }
        os.write("\\hline\n");
        os.write("\\end{tabular}\n");
        os.write("\\end{scriptsize}\n");
        os.write("\\end{table}\n");
        os.close();
    }

    public void generateRBoxplotScripts(int rows, int cols, String[] problems, String prefix, boolean notch, Experiment experiment) throws FileNotFoundException, IOException {
        RBoxplot.generateScripts(rows, cols, problems, prefix, notch, this);
    }

    public void generateRWilcoxonScripts(String[] problems, String prefix, Experiment experiment) throws FileNotFoundException, IOException {
        RWilcoxon.generateScripts(problems, prefix, this);
    }

    public synchronized int[] getNextProblem() {
        int[] res = new int[3];
        int alg = algorithmIndex;
        int runs = irunIndex;
        int prob = problemIndex;
        if (this.problemList_.length == 1) {
            prob = 0;
        }
        if (this.algorithmNameList_.length == 1) {
            alg = 0;
        }
        if (this.independentRuns_ == 1) {
            runs = 0;
        }
        if (problemIndex < this.problemList_.length - 1) {
            ++problemIndex;
        } else if (algorithmIndex < this.algorithmNameList_.length - 1) {
            ++algorithmIndex;
            problemIndex = 0;
        } else if (irunIndex < this.independentRuns_ - 1) {
            ++irunIndex;
            problemIndex = 0;
            algorithmIndex = 0;
        } else {
            this.finished_ = true;
        }
        res[0] = prob;
        res[1] = alg;
        res[2] = runs;
        return res;
    }
}

