/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.experiments.Settings;
import jmetal.experiments.SettingsFactory;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class MainC {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, SecurityException, IOException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        Object[] settingsParams;
        Settings settings = null;
        String algorithmName = "";
        String problemName = "Kursawe";
        String paretoFrontFile = "";
        QualityIndicator indicators = null;
        Object problem = null;
        if (args.length == 0) {
            System.err.println("Sintax error. Usage:");
            System.err.println("a) jmetal.experiments.Main algorithmName ");
            System.err.println("b) jmetal.experiments.Main algorithmName problemName");
            System.err.println("c) jmetal.experiments.Main algorithmName problemName paretoFrontFile");
            System.exit(-1);
        } else if (args.length == 1) {
            algorithmName = args[0];
            settingsParams = new Object[]{problemName};
            settings = new SettingsFactory().getSettingsObject(algorithmName, settingsParams);
        } else if (args.length == 2) {
            algorithmName = args[0];
            problemName = args[1];
            settingsParams = new Object[]{problemName};
            settings = new SettingsFactory().getSettingsObject(algorithmName, settingsParams);
        } else if (args.length == 3) {
            algorithmName = args[0];
            problemName = args[1];
            paretoFrontFile = args[2];
            settingsParams = new Object[]{problemName};
            settings = new SettingsFactory().getSettingsObject(algorithmName, settingsParams);
        }
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler(algorithmName + ".log");
        logger_.addHandler(fileHandler_);
        Properties configuration = new Properties();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(algorithmName + ".conf"));
        configuration.load(isr);
        Algorithm algorithm = settings.configure(configuration);
        isr.close();
        if (args.length == 3) {
            Problem p = algorithm.getProblem();
            indicators = new QualityIndicator(p, paretoFrontFile);
        }
        long initTime = System.currentTimeMillis();
        SolutionSet population = algorithm.execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        logger_.info("Total execution time: " + estimatedTime + "ms");
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
        if (indicators != null) {
            logger_.info("Quality indicators");
            logger_.info("Hypervolume: " + indicators.getHypervolume(population));
            logger_.info("GD         : " + indicators.getGD(population));
            logger_.info("IGD        : " + indicators.getIGD(population));
            logger_.info("Spread     : " + indicators.getSpread(population));
            logger_.info("Epsilon    : " + indicators.getEpsilon(population));
            if (algorithm.getOutputParameter("evaluations") != null) {
                Integer evals = (Integer)algorithm.getOutputParameter("evaluations");
                int evaluations = evals;
                logger_.info("Speed      : " + evaluations + " evaluations");
            }
        }
    }
}

