/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.cellde.CellDE;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class CellDE_Settings
extends Settings {
    public double CR_;
    public double F_;
    public int populationSize_;
    public int archiveSize_;
    public int maxEvaluations_;
    public int archiveFeedback_;

    public CellDE_Settings(String problemName) {
        super(problemName);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.CR_ = 0.5;
        this.F_ = 0.5;
        this.populationSize_ = 100;
        this.archiveSize_ = 100;
        this.maxEvaluations_ = 25000;
        this.archiveFeedback_ = 20;
    }

    @Override
    public Algorithm configure() throws JMException {
        Object[] problemParams = new Object[]{"Real"};
        this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        CellDE algorithm = new CellDE(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("archiveFeedBack", this.archiveFeedback_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("CR", this.CR_);
        parameters.put("F", this.F_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    @Override
    public Algorithm configure(Properties configuration) throws JMException {
        CellDE algorithm = new CellDE(this.problem_);
        this.populationSize_ = Integer.parseInt(configuration.getProperty("populationSize", String.valueOf(this.populationSize_)));
        this.maxEvaluations_ = Integer.parseInt(configuration.getProperty("maxEvaluations", String.valueOf(this.maxEvaluations_)));
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("archiveFeedBack", this.archiveFeedback_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        this.CR_ = Double.parseDouble(configuration.getProperty("CR", String.valueOf(this.CR_)));
        this.F_ = Double.parseDouble(configuration.getProperty("F", String.valueOf(this.F_)));
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("CR", this.CR_);
        parameters.put("F", this.F_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

