/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.smsemoa.FastSMSEMOA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class FastSMSEMOA_Settings
extends Settings {
    public int populationSize_;
    public int maxEvaluations_;
    public double mutationProbability_;
    public double crossoverProbability_;
    public double crossoverDistributionIndex_;
    public double mutationDistributionIndex_;
    public double offset_;

    public FastSMSEMOA_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.populationSize_ = 100;
        this.maxEvaluations_ = 25000;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.crossoverProbability_ = 0.9;
        this.crossoverDistributionIndex_ = 20.0;
        this.mutationDistributionIndex_ = 20.0;
        this.offset_ = 100.0;
    }

    @Override
    public Algorithm configure() throws JMException {
        FastSMSEMOA algorithm = new FastSMSEMOA(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("offset", this.offset_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.crossoverProbability_);
        parameters.put("distributionIndex", this.crossoverDistributionIndex_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("RandomSelection", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    @Override
    public Algorithm configure(Properties configuration) throws JMException {
        FastSMSEMOA algorithm = new FastSMSEMOA(this.problem_);
        this.populationSize_ = Integer.parseInt(configuration.getProperty("populationSize", String.valueOf(this.populationSize_)));
        this.maxEvaluations_ = Integer.parseInt(configuration.getProperty("maxEvaluations", String.valueOf(this.maxEvaluations_)));
        this.offset_ = Double.parseDouble(configuration.getProperty("offset", String.valueOf(this.offset_)));
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("offset", this.offset_);
        this.crossoverProbability_ = Double.parseDouble(configuration.getProperty("crossoverProbability", String.valueOf(this.crossoverProbability_)));
        this.crossoverDistributionIndex_ = Double.parseDouble(configuration.getProperty("crossoverDistributionIndex", String.valueOf(this.crossoverDistributionIndex_)));
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.crossoverProbability_);
        parameters.put("distributionIndex", this.crossoverDistributionIndex_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        this.mutationProbability_ = Double.parseDouble(configuration.getProperty("mutationProbability", String.valueOf(this.mutationProbability_)));
        this.mutationDistributionIndex_ = Double.parseDouble(configuration.getProperty("mutationDistributionIndex", String.valueOf(this.mutationDistributionIndex_)));
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("RandomSelection", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

