/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.mochc.MOCHC;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class MOCHC_Settings
extends Settings {
    int populationSize_;
    int maxEvaluations_;
    double initialConvergenceCount_;
    double preservedPopulation_;
    int convergenceValue_;
    double crossoverProbability_;
    double mutationProbability_;

    public MOCHC_Settings(String problemName) {
        super(problemName);
        Object[] problemParams = new Object[]{"Binary"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.populationSize_ = 100;
        this.maxEvaluations_ = 25000;
        this.initialConvergenceCount_ = 0.25;
        this.preservedPopulation_ = 0.05;
        this.convergenceValue_ = 3;
        this.crossoverProbability_ = 1.0;
        this.mutationProbability_ = 0.35;
    }

    @Override
    public Algorithm configure() throws JMException {
        MOCHC algorithm = new MOCHC(this.problem_);
        algorithm.setInputParameter("initialConvergenceCount", this.initialConvergenceCount_);
        algorithm.setInputParameter("preservedPopulation", this.preservedPopulation_);
        algorithm.setInputParameter("convergenceValue", this.convergenceValue_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        parameters.put("probability", Double.valueOf(this.crossoverProbability_));
        Crossover crossover = CrossoverFactory.getCrossoverOperator("HUXCrossover", parameters);
        parameters = null;
        Selection parentsSelection = SelectionFactory.getSelectionOperator("RandomSelection", parameters);
        parameters = new HashMap();
        parameters.put("problem", this.problem_);
        Selection newGenerationSelection = SelectionFactory.getSelectionOperator("RankingAndCrowdingSelection", parameters);
        parameters = new HashMap();
        parameters.put("probability", Double.valueOf(this.mutationProbability_));
        Mutation mutation = MutationFactory.getMutationOperator("BitFlipMutation", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("cataclysmicMutation", mutation);
        algorithm.addOperator("parentSelection", parentsSelection);
        algorithm.addOperator("newGenerationSelection", newGenerationSelection);
        return algorithm;
    }

    @Override
    public Algorithm configure(Properties configuration) throws JMException {
        MOCHC algorithm = new MOCHC(this.problem_);
        this.populationSize_ = Integer.parseInt(configuration.getProperty("populationSize", String.valueOf(this.populationSize_)));
        this.maxEvaluations_ = Integer.parseInt(configuration.getProperty("maxEvaluations", String.valueOf(this.maxEvaluations_)));
        this.initialConvergenceCount_ = Double.parseDouble(configuration.getProperty("initialConvergenceCount", String.valueOf(this.initialConvergenceCount_)));
        this.preservedPopulation_ = Double.parseDouble(configuration.getProperty("preservedPopulation", String.valueOf(this.preservedPopulation_)));
        this.convergenceValue_ = Integer.parseInt(configuration.getProperty("convergenceValue", String.valueOf(this.convergenceValue_)));
        algorithm.setInputParameter("initialConvergenceCount", this.initialConvergenceCount_);
        algorithm.setInputParameter("preservedPopulation", this.preservedPopulation_);
        algorithm.setInputParameter("convergenceValue", this.convergenceValue_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        this.crossoverProbability_ = Double.parseDouble(configuration.getProperty("crossoverProbability", String.valueOf(this.crossoverProbability_)));
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        parameters.put("probability", Double.valueOf(this.crossoverProbability_));
        Crossover crossover = CrossoverFactory.getCrossoverOperator("HUXCrossover", parameters);
        parameters = null;
        Selection parentsSelection = SelectionFactory.getSelectionOperator("RandomSelection", parameters);
        this.mutationProbability_ = Double.parseDouble(configuration.getProperty("mutationProbability", String.valueOf(this.mutationProbability_)));
        parameters = new HashMap();
        parameters.put("probability", Double.valueOf(this.mutationProbability_));
        Mutation mutation = MutationFactory.getMutationOperator("BitFlipMutation", parameters);
        parameters = new HashMap();
        parameters.put("problem", this.problem_);
        Selection newGenerationSelection = SelectionFactory.getSelectionOperator("RankingAndCrowdingSelection", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("cataclysmicMutation", mutation);
        algorithm.addOperator("parentSelection", parentsSelection);
        algorithm.addOperator("newGenerationSelection", newGenerationSelection);
        return algorithm;
    }
}

