/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.moead.MOEAD_DRA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class MOEAD_DRA_Settings
extends Settings {
    public double CR_;
    public double F_;
    public int populationSize_;
    public int maxEvaluations_;
    public int finalSize_;
    public double mutationProbability_;
    public double mutationDistributionIndex_;
    public int T_;
    public double delta_;
    public int nr_;
    public String dataDirectory_;

    public MOEAD_DRA_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.CR_ = 1.0;
        this.F_ = 0.5;
        this.populationSize_ = 600;
        this.maxEvaluations_ = 300000;
        this.finalSize_ = 300;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.mutationDistributionIndex_ = 20.0;
        this.T_ = (int)(0.1 * (double)this.populationSize_);
        this.delta_ = 0.9;
        this.nr_ = (int)(0.01 * (double)this.populationSize_);
        this.dataDirectory_ = "/Users/antelverde/Dropbox/jMetal/data/MOEAD_parameters/Weight";
    }

    @Override
    public Algorithm configure() throws JMException {
        MOEAD_DRA algorithm = new MOEAD_DRA(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("dataDirectory", this.dataDirectory_);
        algorithm.setInputParameter("finalSize", this.finalSize_);
        algorithm.setInputParameter("T", this.T_);
        algorithm.setInputParameter("delta", this.delta_);
        algorithm.setInputParameter("nr", this.nr_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("CR", this.CR_);
        parameters.put("F", this.F_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }

    @Override
    public Algorithm configure(Properties configuration) throws JMException {
        MOEAD_DRA algorithm = new MOEAD_DRA(this.problem_);
        this.populationSize_ = Integer.parseInt(configuration.getProperty("populationSize", String.valueOf(this.populationSize_)));
        this.maxEvaluations_ = Integer.parseInt(configuration.getProperty("maxEvaluations", String.valueOf(this.maxEvaluations_)));
        this.finalSize_ = Integer.parseInt(configuration.getProperty("finalSize", String.valueOf(this.finalSize_)));
        this.dataDirectory_ = configuration.getProperty("dataDirectory", this.dataDirectory_);
        this.delta_ = Double.parseDouble(configuration.getProperty("delta", String.valueOf(this.delta_)));
        this.T_ = Integer.parseInt(configuration.getProperty("T", String.valueOf(this.T_)));
        this.nr_ = Integer.parseInt(configuration.getProperty("nr", String.valueOf(this.nr_)));
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("dataDirectory", this.dataDirectory_);
        algorithm.setInputParameter("finalSize", this.finalSize_);
        algorithm.setInputParameter("T", this.T_);
        algorithm.setInputParameter("delta", this.delta_);
        algorithm.setInputParameter("nr", this.nr_);
        this.CR_ = Double.parseDouble(configuration.getProperty("CR", String.valueOf(this.CR_)));
        this.F_ = Double.parseDouble(configuration.getProperty("F", String.valueOf(this.F_)));
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("CR", this.CR_);
        parameters.put("F", this.F_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        this.mutationProbability_ = Double.parseDouble(configuration.getProperty("mutationProbability", String.valueOf(this.mutationProbability_)));
        this.mutationDistributionIndex_ = Double.parseDouble(configuration.getProperty("mutationDistributionIndex", String.valueOf(this.mutationDistributionIndex_)));
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }
}

