/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.nsgaII.NSGAIIAdaptive;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;
import jmetal.util.offspring.DifferentialEvolutionOffspring;
import jmetal.util.offspring.Offspring;
import jmetal.util.offspring.PolynomialMutationOffspring;
import jmetal.util.offspring.SBXCrossoverOffspring;

public class NSGAIIAdaptive_Settings
extends Settings {
    public int populationSize_;
    public int maxEvaluations_;
    public double mutationProbability_;
    public double crossoverProbability_;
    public double mutationDistributionIndex_;
    public double crossoverDistributionIndex_;
    public double CR_;
    public double F_;

    public NSGAIIAdaptive_Settings(String problem) throws JMException {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.populationSize_ = 100;
        this.maxEvaluations_ = 150000;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.crossoverProbability_ = 0.9;
        this.mutationDistributionIndex_ = 20.0;
        this.crossoverDistributionIndex_ = 20.0;
        this.CR_ = 1.0;
        this.F_ = 0.5;
    }

    @Override
    public Algorithm configure() throws JMException {
        NSGAIIAdaptive algorithm = new NSGAIIAdaptive(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        Offspring[] getOffspring = new Offspring[]{new DifferentialEvolutionOffspring(this.CR_, this.F_), new SBXCrossoverOffspring(this.crossoverProbability_, this.crossoverDistributionIndex_), new PolynomialMutationOffspring(this.mutationProbability_, this.mutationDistributionIndex_)};
        algorithm.setInputParameter("offspringsCreators", getOffspring);
        HashMap parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament2", parameters);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    @Override
    public Algorithm configure(Properties configuration) throws JMException {
        NSGAIIAdaptive algorithm = new NSGAIIAdaptive(this.problem_);
        this.populationSize_ = Integer.parseInt(configuration.getProperty("populationSize", String.valueOf(this.populationSize_)));
        this.maxEvaluations_ = Integer.parseInt(configuration.getProperty("maxEvaluations", String.valueOf(this.maxEvaluations_)));
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        this.crossoverProbability_ = Double.parseDouble(configuration.getProperty("crossoverProbability", String.valueOf(this.crossoverProbability_)));
        this.crossoverDistributionIndex_ = Double.parseDouble(configuration.getProperty("crossoverDistributionIndex", String.valueOf(this.crossoverDistributionIndex_)));
        this.mutationProbability_ = Double.parseDouble(configuration.getProperty("mutationProbability", String.valueOf(this.mutationProbability_)));
        this.mutationDistributionIndex_ = Double.parseDouble(configuration.getProperty("mutationDistributionIndex", String.valueOf(this.mutationDistributionIndex_)));
        this.CR_ = Double.parseDouble(configuration.getProperty("CR", String.valueOf(this.CR_)));
        this.F_ = Double.parseDouble(configuration.getProperty("F", String.valueOf(this.F_)));
        Offspring[] getOffspring = new Offspring[]{new DifferentialEvolutionOffspring(this.CR_, this.F_), new SBXCrossoverOffspring(this.crossoverProbability_, this.crossoverDistributionIndex_), new PolynomialMutationOffspring(this.mutationProbability_, this.mutationDistributionIndex_)};
        algorithm.setInputParameter("offspringsCreators", getOffspring);
        HashMap parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament2", parameters);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

