/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.omopso.OMOPSO;
import jmetal.operators.mutation.NonUniformMutation;
import jmetal.operators.mutation.UniformMutation;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class OMOPSO_Settings
extends Settings {
    public int swarmSize_;
    public int maxIterations_;
    public int archiveSize_;
    public double perturbationIndex_;
    public double mutationProbability_;

    public OMOPSO_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.swarmSize_ = 100;
        this.maxIterations_ = 250;
        this.archiveSize_ = 100;
        this.perturbationIndex_ = 0.5;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
    }

    @Override
    public Algorithm configure() throws JMException {
        OMOPSO algorithm = new OMOPSO(this.problem_);
        algorithm.setInputParameter("swarmSize", this.swarmSize_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        algorithm.setInputParameter("maxIterations", this.maxIterations_);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("perturbation", this.perturbationIndex_);
        UniformMutation uniformMutation = new UniformMutation(parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("perturbation", this.perturbationIndex_);
        parameters.put("maxIterations", this.maxIterations_);
        NonUniformMutation nonUniformMutation = new NonUniformMutation(parameters);
        algorithm.addOperator("uniformMutation", uniformMutation);
        algorithm.addOperator("nonUniformMutation", nonUniformMutation);
        return algorithm;
    }

    @Override
    public Algorithm configure(Properties configuration) throws JMException {
        OMOPSO algorithm = new OMOPSO(this.problem_);
        this.swarmSize_ = Integer.parseInt(configuration.getProperty("swarmSize", String.valueOf(this.swarmSize_)));
        this.maxIterations_ = Integer.parseInt(configuration.getProperty("maxIterations", String.valueOf(this.maxIterations_)));
        this.archiveSize_ = Integer.parseInt(configuration.getProperty("archiveSize", String.valueOf(this.archiveSize_)));
        algorithm.setInputParameter("swarmSize", this.swarmSize_);
        algorithm.setInputParameter("maxIterations", this.maxIterations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        this.mutationProbability_ = Double.parseDouble(configuration.getProperty("mutationProbability", String.valueOf(this.mutationProbability_)));
        this.perturbationIndex_ = Double.parseDouble(configuration.getProperty("perturbationIndex", String.valueOf(this.mutationProbability_)));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("perturbation", this.perturbationIndex_);
        UniformMutation uniformMutation = new UniformMutation(parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("perturbation", this.perturbationIndex_);
        parameters.put("maxIterations", this.maxIterations_);
        NonUniformMutation nonUniformMutation = new NonUniformMutation(parameters);
        algorithm.addOperator("uniformMutation", uniformMutation);
        algorithm.addOperator("nonUniformMutation", nonUniformMutation);
        return algorithm;
    }
}

