/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.paes.PAES;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class PAES_Settings
extends Settings {
    public int maxEvaluations_;
    public int archiveSize_;
    public int biSections_;
    public double mutationProbability_;
    public double mutationDistributionIndex_;

    public PAES_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.maxEvaluations_ = 25000;
        this.archiveSize_ = 100;
        this.biSections_ = 5;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.mutationDistributionIndex_ = 20.0;
    }

    @Override
    public Algorithm configure() throws JMException {
        PAES algorithm = new PAES(this.problem_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("biSections", this.biSections_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }

    @Override
    public Algorithm configure(Properties configuration) throws JMException {
        PAES algorithm = new PAES(this.problem_);
        this.archiveSize_ = Integer.parseInt(configuration.getProperty("archiveSize", String.valueOf(this.archiveSize_)));
        this.maxEvaluations_ = Integer.parseInt(configuration.getProperty("maxEvaluations", String.valueOf(this.maxEvaluations_)));
        this.biSections_ = Integer.parseInt(configuration.getProperty("biSections", String.valueOf(this.biSections_)));
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("biSections", this.biSections_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        this.mutationProbability_ = Double.parseDouble(configuration.getProperty("mutationProbability", String.valueOf(this.mutationProbability_)));
        this.mutationDistributionIndex_ = Double.parseDouble(configuration.getProperty("mutationDistributionIndex", String.valueOf(this.mutationDistributionIndex_)));
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }
}

