/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import java.util.Properties;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.smpso.pSMPSO;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;
import jmetal.util.parallel.MultithreadedEvaluator;

public class pSMPSO_Settings
extends Settings {
    public int swarmSize_;
    public int maxIterations_;
    public int archiveSize_;
    public double mutationDistributionIndex_;
    public double mutationProbability_;
    public int numberOfThreads_;

    public pSMPSO_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.swarmSize_ = 100;
        this.maxIterations_ = 250;
        this.archiveSize_ = 100;
        this.mutationDistributionIndex_ = 20.0;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.numberOfThreads_ = 8;
    }

    @Override
    public Algorithm configure() throws JMException {
        MultithreadedEvaluator parallelEvaluator = new MultithreadedEvaluator(this.numberOfThreads_);
        pSMPSO algorithm = new pSMPSO(this.problem_, parallelEvaluator);
        algorithm.setInputParameter("swarmSize", this.swarmSize_);
        algorithm.setInputParameter("maxIterations", this.maxIterations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }

    @Override
    public Algorithm configure(Properties configuration) throws JMException {
        this.numberOfThreads_ = Integer.parseInt(configuration.getProperty("numberOfThreads", String.valueOf(this.numberOfThreads_)));
        MultithreadedEvaluator parallelEvaluator = new MultithreadedEvaluator(this.numberOfThreads_);
        pSMPSO algorithm = new pSMPSO(this.problem_, parallelEvaluator);
        this.swarmSize_ = Integer.parseInt(configuration.getProperty("swarmSize", String.valueOf(this.swarmSize_)));
        this.maxIterations_ = Integer.parseInt(configuration.getProperty("maxIterations", String.valueOf(this.maxIterations_)));
        this.archiveSize_ = Integer.parseInt(configuration.getProperty("archiveSize", String.valueOf(this.archiveSize_)));
        algorithm.setInputParameter("swarmSize", this.swarmSize_);
        algorithm.setInputParameter("maxIterations", this.maxIterations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        this.mutationProbability_ = Double.parseDouble(configuration.getProperty("mutationProbability", String.valueOf(this.mutationProbability_)));
        this.mutationDistributionIndex_ = Double.parseDouble(configuration.getProperty("mutationDistributionIndex", String.valueOf(this.mutationDistributionIndex_)));
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }
}

