/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.studies;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.experiments.Experiment;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.NSGAII_Settings;
import jmetal.experiments.util.Friedman;
import jmetal.util.JMException;

public class jMetalExperiment
extends Experiment {
    @Override
    public void algorithmSettings(String problemName, int problemIndex, Algorithm[] algorithm) throws ClassNotFoundException {
        try {
            int i;
            int numberOfAlgorithms = this.algorithmNameList_.length;
            HashMap[] parameters = new HashMap[numberOfAlgorithms];
            for (i = 0; i < numberOfAlgorithms; ++i) {
                parameters[i] = new HashMap();
            }
            if (!this.paretoFrontFile_[problemIndex].equals("")) {
                for (i = 0; i < numberOfAlgorithms; ++i) {
                    parameters[i].put("paretoFrontFile_", this.paretoFrontFile_[problemIndex]);
                }
            }
            algorithm[0] = new NSGAII_Settings(problemName).configure(parameters[0]);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(jMetalExperiment.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(jMetalExperiment.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JMException ex) {
            Logger.getLogger(jMetalExperiment.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws JMException, IOException {
        jMetalExperiment exp = new jMetalExperiment();
        exp.experimentName_ = "leaders_experiments";
        exp.algorithmNameList_ = new String[]{"SMPSOhv3", "SMSEMOA", "NSGA-II"};
        exp.problemList_ = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "ZDT6", "DTLZ1", "DTLZ2", "DTLZ3", "DTLZ4", "DTLZ5", "DTLZ6", "DTLZ7", "WFG1", "WFG2", "WFG3", "WFG4", "WFG5", "WFG6", "WFG7", "WFG8", "WFG9"};
        exp.paretoFrontFile_ = new String[]{"ZDT1.pf", "ZDT2.pf", "ZDT3.pf", "ZDT4.pf", "ZDT6.pf", "DTLZ1.3D.pf", "DTLZ2.3D.pf", "DTLZ3.3D.pf", "DTLZ4.3D.pf", "DTLZ5.3D.pf", "DTLZ6.3D.pf", "DTLZ7.3D.pf", "WFG1.pf", "WFG2.pf", "WFG3.pf", "WFG4.pf", "WFG5.pf", "WFG6.pf", "WFG7.pf", "WFG8.pf", "WFG9.pf"};
        exp.indicatorList_ = new String[]{"HV", "EPSILON"};
        int numberOfAlgorithms = exp.algorithmNameList_.length;
        exp.experimentBaseDirectory_ = "/home/juan/Dropbox/Juanjo (1)/CEC2013/" + exp.experimentName_;
        exp.paretoFrontDirectory_ = "/home/juan/Dropbox/fronts";
        exp.algorithmSettings_ = new Settings[numberOfAlgorithms];
        exp.independentRuns_ = 30;
        exp.initExperiment();
        Friedman test = new Friedman(exp);
        test.executeTest("EPSILON");
        test.executeTest("HV");
        test.executeTest("SPREAD");
        test.executeTest("IGD");
        exp.generateLatexTables();
        String prefix = new String("PSOses");
        String[] problems = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "ZDT6", "DTLZ1", "DTLZ2", "DTLZ4", "DTLZ5", "DTLZ6", "DTLZ7", "WFG1", "WFG2", "WFG3", "WFG4", "WFG5", "WFG6", "WFG7", "WFG8", "WFG9"};
        exp.generateRWilcoxonScripts(problems, prefix, exp);
    }
}

