/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.studies;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.experiments.Experiment;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.MOEAD_Settings;
import jmetal.experiments.settings.pMOEAD_Settings;
import jmetal.experiments.util.Friedman;
import jmetal.util.JMException;

public class pMOEADStudy
extends Experiment {
    @Override
    public void algorithmSettings(String problemName, int problemIndex, Algorithm[] algorithm) throws ClassNotFoundException {
        try {
            int i;
            int numberOfAlgorithms = this.algorithmNameList_.length;
            HashMap[] parameters = new HashMap[numberOfAlgorithms];
            for (i = 0; i < numberOfAlgorithms; ++i) {
                parameters[i] = new HashMap();
            }
            if (this.paretoFrontFile_[problemIndex] != null && !this.paretoFrontFile_[problemIndex].equals("")) {
                for (i = 0; i < numberOfAlgorithms; ++i) {
                    parameters[i].put("paretoFrontFile_", this.paretoFrontFile_[problemIndex]);
                }
            }
            algorithm[0] = new MOEAD_Settings(problemName).configure(parameters[0]);
            for (i = 1; i < numberOfAlgorithms; ++i) {
                algorithm[i] = new pMOEAD_Settings(problemName).configure(parameters[i]);
            }
            algorithm[1].setInputParameter("numberOfThreads", 1);
            algorithm[2].setInputParameter("numberOfThreads", 2);
            algorithm[3].setInputParameter("numberOfThreads", 4);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(pMOEADStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(pMOEADStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JMException ex) {
            Logger.getLogger(pMOEADStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws JMException, IOException {
        pMOEADStudy exp = new pMOEADStudy();
        exp.experimentName_ = "pMOEADStudy";
        exp.algorithmNameList_ = new String[]{"MOEADseq", "pMOEAD1T", "pMOEAD2T", "pMOEAD4T"};
        exp.problemList_ = new String[]{"LZ09_F1", "LZ09_F2", "LZ09_F3", "LZ09_F4", "LZ09_F5", "LZ09_F6", "LZ09_F7", "LZ09_F8", "LZ09_F9"};
        exp.paretoFrontFile_ = new String[9];
        exp.indicatorList_ = new String[]{"EPSILON"};
        int numberOfAlgorithms = exp.algorithmNameList_.length;
        exp.experimentBaseDirectory_ = "D:/Sheffield/experiments/" + exp.experimentName_;
        exp.paretoFrontDirectory_ = "";
        exp.algorithmSettings_ = new Settings[numberOfAlgorithms];
        exp.independentRuns_ = 10;
        exp.initExperiment();
        int numberOfThreads = 1;
        exp.runExperiment(1);
        exp.generateQualityIndicators();
        exp.generateLatexTables();
        int rows = 3;
        int columns = 3;
        String prefix = new String("LZ09");
        String[] problems = new String[]{"LZ09_F1", "LZ09_F2", "LZ09_F3", "LZ09_F4", "LZ09_F5", "LZ09_F6", "LZ09_F7", "LZ09_F8", "LZ09_F9"};
        boolean notch = false;
        exp.generateRBoxplotScripts(rows, columns, problems, prefix, false, exp);
        exp.generateRWilcoxonScripts(problems, prefix, exp);
        Friedman test = new Friedman(exp);
        test.executeTest("EPSILON");
    }
}

