/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jmetal.experiments.Experiment;

public class RWilcoxon {
    public static void generateScripts(String[] problems, String prefix, Experiment experiment) throws IOException {
        String rDirectory = "R";
        rDirectory = experiment.experimentBaseDirectory_ + "/" + rDirectory;
        System.out.println("R    : " + rDirectory);
        File rOutput = new File(rDirectory);
        if (!rOutput.exists()) {
            new File(rDirectory).mkdirs();
            System.out.println("Creating " + rDirectory + " directory");
        }
        for (int indicator = 0; indicator < experiment.indicatorList_.length; ++indicator) {
            int i;
            System.out.println("Indicator: " + experiment.indicatorList_[indicator]);
            String rFile = rDirectory + "/" + prefix + "." + experiment.indicatorList_[indicator] + ".Wilcox.R";
            String texFile = rDirectory + "/" + prefix + "." + experiment.indicatorList_[indicator] + ".Wilcox.tex";
            FileWriter os = new FileWriter(rFile, false);
            String output = "write(\"\", \"" + texFile + "\",append=FALSE)";
            os.write(output + "\n");
            String dataDirectory = experiment.experimentBaseDirectory_ + "/data";
            os.write("resultDirectory<-\"" + dataDirectory + "\"" + "\n");
            output = "latexHeader <- function() {\n  write(\"\\\\documentclass{article}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\title{StandardStudy}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\usepackage{amssymb}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\author{A.J.Nebro}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\begin{document}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\maketitle\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\section{Tables}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\\", \"" + texFile + "\", append=TRUE)" + "\n" + "}" + "\n";
            os.write(output + "\n");
            String latexTableLabel = "";
            String latexTabularAlignment = "";
            String latexTableFirstLine = "";
            String latexTableCaption = "";
            latexTableCaption = "  write(\"\\\\caption{\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(problem, \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"." + experiment.indicatorList_[indicator] + ".}\", \"" + texFile + "\", append=TRUE)" + "\n";
            latexTableLabel = "  write(\"\\\\label{Table:\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(problem, \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"." + experiment.indicatorList_[indicator] + ".}\", \"" + texFile + "\", append=TRUE)" + "\n";
            latexTabularAlignment = "l";
            latexTableFirstLine = "\\\\hline ";
            for (int i2 = 1; i2 < experiment.algorithmNameList_.length; ++i2) {
                latexTabularAlignment = latexTabularAlignment + "c";
                latexTableFirstLine = latexTableFirstLine + " & " + experiment.algorithmNameList_[i2];
            }
            latexTableFirstLine = latexTableFirstLine + "\\\\\\\\ \"";
            output = "latexTableHeader <- function(problem, tabularString, latexTableFirstLine) {\n  write(\"\\\\begin{table}\", \"" + texFile + "\", append=TRUE)" + "\n" + latexTableCaption + "\n" + latexTableLabel + "\n" + "  write(\"\\\\centering\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\begin{scriptsize}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\begin{tabular}{\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(tabularString, \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(latexTableFirstLine, \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\hline \", \"" + texFile + "\", append=TRUE)" + "\n" + "}" + "\n";
            os.write(output + "\n");
            output = "latexTableTail <- function() { \n  write(\"\\\\hline\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\end{tabular}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\end{scriptsize}\", \"" + texFile + "\", append=TRUE)" + "\n" + "  write(\"\\\\end{table}\", \"" + texFile + "\", append=TRUE)" + "\n" + "}" + "\n";
            os.write(output + "\n");
            output = "latexTail <- function() { \n  write(\"\\\\end{document}\", \"" + texFile + "\", append=TRUE)" + "\n" + "}" + "\n";
            os.write(output + "\n");
            output = experiment.indicatorMinimize_.get(experiment.indicatorList_[indicator]) != false ? "printTableLine <- function(indicator, algorithm1, algorithm2, i, j, problem) { \n  file1<-paste(resultDirectory, algorithm1, sep=\"/\")\n  file1<-paste(file1, problem, sep=\"/\")\n  file1<-paste(file1, indicator, sep=\"/\")\n  data1<-scan(file1)\n  file2<-paste(resultDirectory, algorithm2, sep=\"/\")\n  file2<-paste(file2, problem, sep=\"/\")\n  file2<-paste(file2, indicator, sep=\"/\")\n  data2<-scan(file2)\n  if (i == j) {\n    write(\"-- \", \"" + texFile + "\", append=TRUE)" + "\n" + "  }" + "\n" + "  else if (i < j) {" + "\n" + "    if (wilcox.test(data1, data2)$p.value <= 0.05) {" + "\n" + "      if (median(data1) <= median(data2)) {" + "\n" + "        write(\"$\\\\blacktriangle$\", \"" + texFile + "\", append=TRUE)" + "\n" + "      }" + "\n" + "      else {" + "\n" + "        write(\"$\\\\triangledown$\", \"" + texFile + "\", append=TRUE) " + "\n" + "      }" + "\n" + "    }" + "\n" + "    else {" + "\n" + "      write(\"--\", \"" + texFile + "\", append=TRUE) " + "\n" + "    }" + "\n" + "  }" + "\n" + "  else {" + "\n" + "    write(\" \", \"" + texFile + "\", append=TRUE)" + "\n" + "  }" + "\n" + "}" + "\n" : "printTableLine <- function(indicator, algorithm1, algorithm2, i, j, problem) { \n  file1<-paste(resultDirectory, algorithm1, sep=\"/\")\n  file1<-paste(file1, problem, sep=\"/\")\n  file1<-paste(file1, indicator, sep=\"/\")\n  data1<-scan(file1)\n  file2<-paste(resultDirectory, algorithm2, sep=\"/\")\n  file2<-paste(file2, problem, sep=\"/\")\n  file2<-paste(file2, indicator, sep=\"/\")\n  data2<-scan(file2)\n  if (i == j) {\n    write(\"--\", \"" + texFile + "\", append=TRUE)" + "\n" + "  }" + "\n" + "  else if (i < j) {" + "\n" + "    if (wilcox.test(data1, data2)$p.value <= 0.05) {" + "\n" + "      if (median(data1) >= median(data2)) {" + "\n" + "        write(\"$\\\\blacktriangle$\", \"" + texFile + "\", append=TRUE)" + "\n" + "      }" + "\n" + "      else {" + "\n" + "        write(\"$\\\\triangledown$\", \"" + texFile + "\", append=TRUE) " + "\n" + "      }" + "\n" + "    }" + "\n" + "    else {" + "\n" + "      write(\"--\", \"" + texFile + "\", append=TRUE) " + "\n" + "    }" + "\n" + "  }" + "\n" + "  else {" + "\n" + "    write(\" \", \"" + texFile + "\", append=TRUE)" + "\n" + "  }" + "\n" + "}" + "\n";
            os.write(output + "\n");
            output = "### START OF SCRIPT ";
            os.write(output + "\n");
            String problemList = "problemList <-c(";
            String algorithmList = "algorithmList <-c(";
            for (i = 0; i < problems.length - 1; ++i) {
                problemList = problemList + "\"" + problems[i] + "\", ";
            }
            problemList = problemList + "\"" + problems[problems.length - 1] + "\") ";
            for (i = 0; i < experiment.algorithmNameList_.length - 1; ++i) {
                algorithmList = algorithmList + "\"" + experiment.algorithmNameList_[i] + "\", ";
            }
            algorithmList = algorithmList + "\"" + experiment.algorithmNameList_[experiment.algorithmNameList_.length - 1] + "\") ";
            latexTabularAlignment = "l";
            for (i = 1; i < experiment.algorithmNameList_.length; ++i) {
                latexTabularAlignment = latexTabularAlignment + "c";
            }
            String tabularString = "tabularString <-c(\"" + latexTabularAlignment + "\"" + ") ";
            String tableFirstLine = "latexTableFirstLine <-c(\"" + latexTableFirstLine + ") ";
            output = "# Constants\n" + problemList + "\n" + algorithmList + "\n" + tabularString + "\n" + tableFirstLine + "\n" + "indicator<-\"" + experiment.indicatorList_[indicator] + "\"";
            os.write(output + "\n");
            output = "\n # Step 1.  Writes the latex header\nlatexHeader()";
            os.write(output + "\n");
            output = "# Step 2. Problem loop \nfor (problem in problemList) {\n  latexTableHeader(problem,  tabularString, latexTableFirstLine)\n\n  indx = 0\n  for (i in algorithmList) {\n    if (i != \"" + experiment.algorithmNameList_[experiment.algorithmNameList_.length - 1] + "\") {" + "\n" + "      write(i , \"" + texFile + "\", append=TRUE)" + "\n" + "      write(\" & \", \"" + texFile + "\", append=TRUE)" + "\n" + "      jndx = 0 " + "\n" + "      for (j in algorithmList) {" + "\n" + "        if (jndx != 0) {" + "\n" + "          if (indx != jndx) {" + "\n" + "            printTableLine(indicator, i, j, indx, jndx, problem)" + "\n" + "          }" + "\n" + "          else {" + "\n" + "            write(\"  \", \"" + texFile + "\", append=TRUE)" + "\n" + "          }" + "\n" + "          if (j != \"" + experiment.algorithmNameList_[experiment.algorithmNameList_.length - 1] + "\") {" + "\n" + "            write(\" & \", \"" + texFile + "\", append=TRUE)" + "\n" + "          }" + "\n" + "          else {" + "\n" + "            write(\" \\\\\\\\ \", \"" + texFile + "\", append=TRUE)" + "\n" + "          }" + "\n" + "        }" + "\n" + "        jndx = jndx + 1" + "\n" + "      }" + "\n" + "      indx = indx + 1" + "\n" + "    }" + "\n" + "  }" + "\n" + "\n" + "  latexTableTail()" + "\n" + "} # for problem" + "\n";
            os.write(output + "\n");
            problemList = "";
            for (String problem : problems) {
                problemList = problemList + problem + " ";
            }
            latexTabularAlignment = "| l | ";
            latexTableFirstLine = "\\\\hline \\\\multicolumn{1}{|c|}{}";
            for (int i3 = 1; i3 < experiment.algorithmNameList_.length; ++i3) {
                for (String problem : problems) {
                    latexTabularAlignment = latexTabularAlignment + "p{0.15cm}  ";
                }
                latexTableFirstLine = latexTableFirstLine + " & \\\\multicolumn{" + problems.length + "}{c|}{" + experiment.algorithmNameList_[i3] + "}";
                latexTabularAlignment = latexTabularAlignment + " | ";
            }
            latexTableFirstLine = latexTableFirstLine + " \\\\\\\\";
            tabularString = "tabularString <-c(\"" + latexTabularAlignment + "\"" + ") ";
            latexTableFirstLine = "latexTableFirstLine <-c(\"" + latexTableFirstLine + "\"" + ") ";
            output = tabularString;
            os.write(output + "\n" + "\n");
            output = latexTableFirstLine;
            os.write(output + "\n" + "\n");
            output = "# Step 3. Problem loop \nlatexTableHeader(\"" + problemList + "\", tabularString, latexTableFirstLine)" + "\n\n" + "indx = 0" + "\n" + "for (i in algorithmList) {" + "\n" + "  if (i != \"" + experiment.algorithmNameList_[experiment.algorithmNameList_.length - 1] + "\") {" + "\n" + "    write(i , \"" + texFile + "\", append=TRUE)" + "\n" + "    write(\" & \", \"" + texFile + "\", append=TRUE)" + "\n" + "\n" + "    jndx = 0" + "\n" + "    for (j in algorithmList) {" + "\n" + "      for (problem in problemList) {" + "\n" + "        if (jndx != 0) {" + "\n" + "          if (i != j) {" + "\n" + "            printTableLine(indicator, i, j, indx, jndx, problem)" + "\n" + "          }" + "\n" + "          else {" + "\n" + "            write(\"  \", \"" + texFile + "\", append=TRUE)" + "\n" + "          } " + "\n" + "          if (problem == \"" + problems[problems.length - 1] + "\") {" + "\n" + "            if (j == \"" + experiment.algorithmNameList_[experiment.algorithmNameList_.length - 1] + "\") {" + "\n" + "              write(\" \\\\\\\\ \", \"" + texFile + "\", append=TRUE)" + "\n" + "            } " + "\n" + "            else {" + "\n" + "              write(\" & \", \"" + texFile + "\", append=TRUE)" + "\n" + "            }" + "\n" + "          }" + "\n" + "     else {" + "\n" + "    write(\"&\", \"" + texFile + "\", append=TRUE)" + "\n" + "     }" + "\n" + "        }" + "\n" + "      }" + "\n" + "      jndx = jndx + 1" + "\n" + "    }" + "\n" + "    indx = indx + 1" + "\n" + "  }" + "\n" + "} # for algorithm" + "\n" + "\n" + "  latexTableTail()" + "\n";
            os.write(output + "\n");
            output = "#Step 3. Writes the end of latex file \nlatexTail()\n";
            os.write(output + "\n");
            os.close();
        }
    }
}

