/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.abyss;

import java.util.Comparator;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.localSearch.LocalSearch;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.Spea2Fitness;
import jmetal.util.archive.CrowdingArchive;
import jmetal.util.comparators.CrowdingDistanceComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.EqualSolutions;
import jmetal.util.comparators.FitnessComparator;
import jmetal.util.wrapper.XReal;

public class AbYSS
extends Algorithm {
    int numberOfSubranges_;
    int[] sumOfFrequencyValues_;
    int[] sumOfReverseFrequencyValues_;
    int[][] frequency_;
    int[][] reverseFrequency_;
    private SolutionSet solutionSet_ = null;
    private CrowdingArchive archive_ = null;
    private SolutionSet refSet1_ = null;
    private SolutionSet refSet2_ = null;
    private SolutionSet subSet_ = null;
    private int solutionSetSize_;
    private int archiveSize_;
    private int refSet1Size_;
    private int refSet2Size_;
    private int maxEvaluations;
    private int evaluations_;
    private Comparator dominance_;
    private Comparator equal_;
    private Comparator fitness_;
    private Comparator crowdingDistance_;
    private Operator crossoverOperator_;
    private LocalSearch improvementOperator_;
    private Distance distance_;

    public AbYSS(Problem problem) {
        super(problem);
    }

    public void initParam() {
        this.solutionSetSize_ = (Integer)this.getInputParameter("populationSize");
        this.refSet1Size_ = (Integer)this.getInputParameter("refSet1Size");
        this.refSet2Size_ = (Integer)this.getInputParameter("refSet2Size");
        this.archiveSize_ = (Integer)this.getInputParameter("archiveSize");
        this.maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        this.solutionSet_ = new SolutionSet(this.solutionSetSize_);
        this.archive_ = new CrowdingArchive(this.archiveSize_, this.problem_.getNumberOfObjectives());
        this.refSet1_ = new SolutionSet(this.refSet1Size_);
        this.refSet2_ = new SolutionSet(this.refSet2Size_);
        this.subSet_ = new SolutionSet(this.solutionSetSize_ * 1000);
        this.evaluations_ = 0;
        this.numberOfSubranges_ = 4;
        this.dominance_ = new DominanceComparator();
        this.equal_ = new EqualSolutions();
        this.fitness_ = new FitnessComparator();
        this.crowdingDistance_ = new CrowdingDistanceComparator();
        this.distance_ = new Distance();
        this.sumOfFrequencyValues_ = new int[this.problem_.getNumberOfVariables()];
        this.sumOfReverseFrequencyValues_ = new int[this.problem_.getNumberOfVariables()];
        this.frequency_ = new int[this.numberOfSubranges_][this.problem_.getNumberOfVariables()];
        this.reverseFrequency_ = new int[this.numberOfSubranges_][this.problem_.getNumberOfVariables()];
        this.crossoverOperator_ = (Operator)this.operators_.get("crossover");
        this.improvementOperator_ = (LocalSearch)this.operators_.get("improvement");
        this.improvementOperator_.setParameter("archive", this.archive_);
    }

    public Solution diversificationGeneration() throws JMException, ClassNotFoundException {
        Solution solution = new Solution(this.problem_);
        XReal wrapperSolution = new XReal(solution);
        for (int i = 0; i < this.problem_.getNumberOfVariables(); ++i) {
            double value;
            int range;
            this.sumOfReverseFrequencyValues_[i] = 0;
            for (int j = 0; j < this.numberOfSubranges_; ++j) {
                this.reverseFrequency_[j][i] = this.sumOfFrequencyValues_[i] - this.frequency_[j][i];
                int n = i;
                this.sumOfReverseFrequencyValues_[n] = this.sumOfReverseFrequencyValues_[n] + this.reverseFrequency_[j][i];
            }
            if (this.sumOfReverseFrequencyValues_[i] == 0) {
                range = PseudoRandom.randInt(0, this.numberOfSubranges_ - 1);
            } else {
                value = PseudoRandom.randInt(0, this.sumOfReverseFrequencyValues_[i] - 1);
                range = 0;
                while (value > (double)this.reverseFrequency_[range][i]) {
                    value -= (double)this.reverseFrequency_[range][i];
                    ++range;
                }
            }
            int[] nArray = this.frequency_[range];
            int n = i;
            nArray[n] = nArray[n] + 1;
            int n2 = i;
            this.sumOfFrequencyValues_[n2] = this.sumOfFrequencyValues_[n2] + 1;
            double low = this.problem_.getLowerLimit(i) + (double)range * (this.problem_.getUpperLimit(i) - this.problem_.getLowerLimit(i)) / (double)this.numberOfSubranges_;
            double high = low + (this.problem_.getUpperLimit(i) - this.problem_.getLowerLimit(i)) / (double)this.numberOfSubranges_;
            value = PseudoRandom.randDouble(low, high);
            wrapperSolution.setValue(i, value);
        }
        return solution;
    }

    public void referenceSetUpdate(boolean build) throws JMException {
        if (build) {
            Solution individual;
            int i;
            new Spea2Fitness(this.solutionSet_).fitnessAssign();
            this.solutionSet_.sort(this.fitness_);
            for (i = 0; i < this.refSet1Size_; ++i) {
                individual = this.solutionSet_.get(0);
                this.solutionSet_.remove(0);
                individual.unMarked();
                this.refSet1_.add(individual);
            }
            for (i = 0; i < this.solutionSet_.size(); ++i) {
                individual = this.solutionSet_.get(i);
                individual.setDistanceToSolutionSet(this.distance_.distanceToSolutionSetInSolutionSpace(individual, this.refSet1_));
            }
            int size = this.refSet2Size_;
            if (this.solutionSet_.size() < this.refSet2Size_) {
                size = this.solutionSet_.size();
            }
            for (int i2 = 0; i2 < size; ++i2) {
                int j;
                double maxMinimum = 0.0;
                int index = 0;
                for (j = 0; j < this.solutionSet_.size(); ++j) {
                    if (!(this.solutionSet_.get(j).getDistanceToSolutionSet() > maxMinimum)) continue;
                    maxMinimum = this.solutionSet_.get(j).getDistanceToSolutionSet();
                    index = j;
                }
                individual = this.solutionSet_.get(index);
                this.solutionSet_.remove(index);
                for (j = 0; j < this.solutionSet_.size(); ++j) {
                    double aux = this.distance_.distanceBetweenSolutions(this.solutionSet_.get(j), individual);
                    if (!(aux < individual.getDistanceToSolutionSet())) continue;
                    this.solutionSet_.get(j).setDistanceToSolutionSet(aux);
                }
                this.refSet2_.add(individual);
                for (j = 0; j < this.refSet2_.size(); ++j) {
                    for (int k = 0; k < this.refSet2_.size(); ++k) {
                        double aux;
                        if (i2 == j || !((aux = this.distance_.distanceBetweenSolutions(this.refSet2_.get(j), this.refSet2_.get(k))) < this.refSet2_.get(j).getDistanceToSolutionSet())) continue;
                        this.refSet2_.get(j).setDistanceToSolutionSet(aux);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.subSet_.size(); ++i) {
                Solution individual = (Solution)this.improvementOperator_.execute(this.subSet_.get(i));
                this.evaluations_ += this.improvementOperator_.getEvaluations();
                if (this.refSet1Test(individual)) {
                    for (int indSet2 = 0; indSet2 < this.refSet2_.size(); ++indSet2) {
                        double aux = this.distance_.distanceBetweenSolutions(individual, this.refSet2_.get(indSet2));
                        if (!(aux < this.refSet2_.get(indSet2).getDistanceToSolutionSet())) continue;
                        this.refSet2_.get(indSet2).setDistanceToSolutionSet(aux);
                    }
                    continue;
                }
                this.refSet2Test(individual);
            }
            this.subSet_.clear();
        }
    }

    public boolean refSet2Test(Solution solution) throws JMException {
        if (this.refSet2_.size() < this.refSet2Size_) {
            solution.setDistanceToSolutionSet(this.distance_.distanceToSolutionSetInSolutionSpace(solution, this.refSet1_));
            double aux = this.distance_.distanceToSolutionSetInSolutionSpace(solution, this.refSet2_);
            if (aux < solution.getDistanceToSolutionSet()) {
                solution.setDistanceToSolutionSet(aux);
            }
            this.refSet2_.add(solution);
            return true;
        }
        solution.setDistanceToSolutionSet(this.distance_.distanceToSolutionSetInSolutionSpace(solution, this.refSet1_));
        double aux = this.distance_.distanceToSolutionSetInSolutionSpace(solution, this.refSet2_);
        if (aux < solution.getDistanceToSolutionSet()) {
            solution.setDistanceToSolutionSet(aux);
        }
        double peor = 0.0;
        int index = 0;
        for (int i = 0; i < this.refSet2_.size(); ++i) {
            aux = this.refSet2_.get(i).getDistanceToSolutionSet();
            if (!(aux > peor)) continue;
            peor = aux;
            index = i;
        }
        if (solution.getDistanceToSolutionSet() < peor) {
            this.refSet2_.remove(index);
            for (int j = 0; j < this.refSet2_.size(); ++j) {
                aux = this.distance_.distanceBetweenSolutions(this.refSet2_.get(j), solution);
                if (!(aux < this.refSet2_.get(j).getDistanceToSolutionSet())) continue;
                this.refSet2_.get(j).setDistanceToSolutionSet(aux);
            }
            solution.unMarked();
            this.refSet2_.add(solution);
            return true;
        }
        return false;
    }

    public boolean refSet1Test(Solution solution) {
        boolean dominated = false;
        int i = 0;
        while (i < this.refSet1_.size()) {
            int flag = this.dominance_.compare(solution, this.refSet1_.get(i));
            if (flag == -1) {
                this.refSet1_.remove(i);
                continue;
            }
            if (flag == 1) {
                dominated = true;
                ++i;
                continue;
            }
            flag = this.equal_.compare(solution, this.refSet1_.get(i));
            if (flag == 0) {
                return true;
            }
            ++i;
        }
        if (!dominated) {
            solution.unMarked();
            if (this.refSet1_.size() < this.refSet1Size_) {
                this.refSet1_.add(solution);
            } else {
                this.archive_.add(solution);
            }
        } else {
            return false;
        }
        return true;
    }

    public int subSetGeneration() throws JMException {
        Solution[] offSpring;
        int j;
        int i;
        Solution[] parents = new Solution[2];
        this.subSet_.clear();
        for (i = 0; i < this.refSet1_.size(); ++i) {
            parents[0] = this.refSet1_.get(i);
            for (j = i + 1; j < this.refSet1_.size(); ++j) {
                parents[1] = this.refSet1_.get(j);
                if (parents[0].isMarked() && parents[1].isMarked()) continue;
                offSpring = (Solution[])this.crossoverOperator_.execute(parents);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluate(offSpring[1]);
                this.problem_.evaluateConstraints(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[1]);
                this.evaluations_ += 2;
                if (this.evaluations_ < this.maxEvaluations) {
                    this.subSet_.add(offSpring[0]);
                    this.subSet_.add(offSpring[1]);
                }
                parents[0].marked();
                parents[1].marked();
            }
        }
        for (i = 0; i < this.refSet2_.size(); ++i) {
            parents[0] = this.refSet2_.get(i);
            for (j = i + 1; j < this.refSet2_.size(); ++j) {
                parents[1] = this.refSet2_.get(j);
                if (parents[0].isMarked() && parents[1].isMarked()) continue;
                offSpring = (Solution[])this.crossoverOperator_.execute(parents);
                this.problem_.evaluateConstraints(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[1]);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluate(offSpring[1]);
                this.evaluations_ += 2;
                if (this.evaluations_ < this.maxEvaluations) {
                    this.subSet_.add(offSpring[0]);
                    this.subSet_.add(offSpring[1]);
                }
                parents[0].marked();
                parents[1].marked();
            }
        }
        return this.subSet_.size();
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        Solution solution;
        this.initParam();
        for (int i = 0; i < this.solutionSetSize_; ++i) {
            solution = this.diversificationGeneration();
            this.problem_.evaluate(solution);
            this.problem_.evaluateConstraints(solution);
            ++this.evaluations_;
            solution = (Solution)this.improvementOperator_.execute(solution);
            this.evaluations_ += this.improvementOperator_.getEvaluations();
            this.solutionSet_.add(solution);
        }
        int newSolutions = 0;
        while (this.evaluations_ < this.maxEvaluations) {
            this.referenceSetUpdate(true);
            newSolutions = this.subSetGeneration();
            while (newSolutions > 0) {
                this.referenceSetUpdate(false);
                if (this.evaluations_ >= this.maxEvaluations) {
                    return this.archive_;
                }
                newSolutions = this.subSetGeneration();
            }
            if (this.evaluations_ >= this.maxEvaluations) continue;
            this.solutionSet_.clear();
            for (int i = 0; i < this.refSet1_.size(); ++i) {
                solution = this.refSet1_.get(i);
                solution.unMarked();
                solution = (Solution)this.improvementOperator_.execute(solution);
                this.evaluations_ += this.improvementOperator_.getEvaluations();
                this.solutionSet_.add(solution);
            }
            this.refSet1_.clear();
            this.refSet2_.clear();
            this.distance_.crowdingDistanceAssignment(this.archive_, this.problem_.getNumberOfObjectives());
            this.archive_.sort(this.crowdingDistance_);
            int insert = this.solutionSetSize_ / 2;
            if (insert > this.archive_.size()) {
                insert = this.archive_.size();
            }
            if (insert > this.solutionSetSize_ - this.solutionSet_.size()) {
                insert = this.solutionSetSize_ - this.solutionSet_.size();
            }
            for (int i = 0; i < insert; ++i) {
                solution = new Solution(this.archive_.get(i));
                solution.unMarked();
                this.solutionSet_.add(solution);
            }
            while (this.solutionSet_.size() < this.solutionSetSize_) {
                solution = this.diversificationGeneration();
                this.problem_.evaluateConstraints(solution);
                this.problem_.evaluate(solution);
                ++this.evaluations_;
                solution = (Solution)this.improvementOperator_.execute(solution);
                this.evaluations_ += this.improvementOperator_.getEvaluations();
                solution.unMarked();
                this.solutionSet_.add(solution);
            }
        }
        this.archive_.printFeasibleFUN("FUN_AbYSS");
        return this.archive_;
    }
}

