/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.abyss;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.abyss.AbYSS;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.localSearch.MutationLocalSearch;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.problems.ZDT.ZDT4;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class AbYSS_main {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, SecurityException, IOException, ClassNotFoundException {
        Problem problem;
        Object[] params;
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler("AbYSS.log");
        logger_.addHandler(fileHandler_);
        QualityIndicator indicators = null;
        if (args.length == 1) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
        } else if (args.length == 2) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
            indicators = new QualityIndicator(problem, args[1]);
        } else {
            problem = new ZDT4("ArrayReal", 10);
        }
        AbYSS algorithm = new AbYSS(problem);
        algorithm.setInputParameter("populationSize", 20);
        algorithm.setInputParameter("refSet1Size", 10);
        algorithm.setInputParameter("refSet2Size", 10);
        algorithm.setInputParameter("archiveSize", 100);
        algorithm.setInputParameter("maxEvaluations", 25000);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", 0.9);
        parameters.put("distributionIndex", 20.0);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 1.0 / (double)problem.getNumberOfVariables());
        parameters.put("distributionIndex", 20.0);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        parameters = new HashMap();
        parameters.put("improvementRounds", 1);
        parameters.put("problem", problem);
        parameters.put("mutation", mutation);
        MutationLocalSearch improvement = new MutationLocalSearch(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("improvement", improvement);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        logger_.info("Total execution time: " + estimatedTime + "ms");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        if (indicators != null) {
            logger_.info("Quality indicators");
            logger_.info("Hypervolume: " + indicators.getHypervolume(population));
            logger_.info("GD         : " + indicators.getGD(population));
            logger_.info("IGD        : " + indicators.getIGD(population));
            logger_.info("Spread     : " + indicators.getSpread(population));
            logger_.info("Epsilon    : " + indicators.getEpsilon(population));
        }
    }
}

