/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.densea;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.CrowdingComparator;
import jmetal.util.comparators.EqualSolutions;

public class DENSEA
extends Algorithm {
    public DENSEA(Problem problem) {
        super(problem);
    }

    public void deleteDuplicates(SolutionSet population) {
        EqualSolutions equalIndividuals = new EqualSolutions();
        for (int i = 0; i < population.size() / 2; ++i) {
            for (int j = i + 1; j < population.size() / 2; ++j) {
                int flag = equalIndividuals.compare(population.get(i), population.get(j));
                if (flag != 0) continue;
                Solution aux = population.get(j);
                population.replace(j, population.get(population.size() / 2 + j));
                population.replace(population.size() / 2 + j, aux);
            }
        }
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        Distance distance = new Distance();
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        SolutionSet population = new SolutionSet(populationSize);
        int evaluations = 0;
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        for (int i = 0; i < populationSize; ++i) {
            Solution newIndividual = new Solution(this.problem_);
            this.problem_.evaluate(newIndividual);
            this.problem_.evaluateConstraints(newIndividual);
            ++evaluations;
            population.add(newIndividual);
        }
        while (evaluations < maxEvaluations) {
            int i;
            int i2;
            SolutionSet P3 = new SolutionSet(populationSize);
            for (i2 = 0; i2 < populationSize / 2; ++i2) {
                Solution[] parents = new Solution[]{(Solution)selectionOperator.execute(population), (Solution)selectionOperator.execute(population)};
                Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offSpring[0]);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[0]);
                ++evaluations;
                mutationOperator.execute(offSpring[1]);
                this.problem_.evaluate(offSpring[1]);
                this.problem_.evaluateConstraints(offSpring[1]);
                ++evaluations;
                P3.add(offSpring[0]);
                P3.add(offSpring[1]);
            }
            Ranking r = new Ranking(P3);
            for (i2 = 0; i2 < r.getNumberOfSubfronts(); ++i2) {
                distance.crowdingDistanceAssignment(r.getSubfront(i2), this.problem_.getNumberOfObjectives());
            }
            P3.sort(new CrowdingComparator());
            population.sort(new CrowdingComparator());
            SolutionSet auxiliar = new SolutionSet(populationSize);
            for (i = 0; i < populationSize / 2; ++i) {
                auxiliar.add(population.get(i));
            }
            for (int j = 0; j < populationSize / 2; ++j) {
                auxiliar.add(population.get(j));
            }
            population = auxiliar;
            r = new Ranking(population);
            for (i = 0; i < r.getNumberOfSubfronts(); ++i) {
                distance.crowdingDistanceAssignment(r.getSubfront(i), this.problem_.getNumberOfObjectives());
            }
        }
        Ranking r = new Ranking(population);
        return r.getSubfront(0);
    }
}

