/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.dmopso;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.Hypervolume;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.qualityIndicator.util.MetricsUtil;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.wrapper.XReal;

public class dMOPSO
extends Algorithm {
    private int swarmSize_;
    private int maxAge_;
    private int maxIterations_;
    private int iteration_;
    private SolutionSet particles_;
    private Solution[] lBest_;
    private Solution[] gBest_;
    private int[] shfGBest_;
    private double[][] speed_;
    private int[] age_;
    double[] z_;
    double[][] lambda_;
    Solution[] indArray_;
    String functionType_ = "_PBI";
    String dataDirectory_;
    QualityIndicator indicators_;
    double r1Max_;
    double r1Min_;
    double r2Max_;
    double r2Min_;
    double C1Max_;
    double C1Min_;
    double C2Max_;
    double C2Min_;
    double WMax_;
    double WMin_;
    double ChVel1_;
    double ChVel2_;
    private double trueHypervolume_;
    private Hypervolume hy_;
    private SolutionSet trueFront_;
    private double[] deltaMax_;
    private double[] deltaMin_;

    public dMOPSO(Problem problem) {
        super(problem);
        this.r1Max_ = 1.0;
        this.r1Min_ = 0.0;
        this.r2Max_ = 1.0;
        this.r2Min_ = 0.0;
        this.C1Max_ = 2.5;
        this.C1Min_ = 1.5;
        this.C2Max_ = 2.5;
        this.C2Min_ = 1.5;
        this.WMax_ = 0.4;
        this.WMin_ = 0.1;
        this.ChVel1_ = -1.0;
        this.ChVel2_ = -1.0;
    }

    public dMOPSO(Problem problem, Vector<Double> variables, String trueParetoFront) throws FileNotFoundException {
        super(problem);
        this.r1Max_ = variables.get(0);
        this.r1Min_ = variables.get(1);
        this.r2Max_ = variables.get(2);
        this.r2Min_ = variables.get(3);
        this.C1Max_ = variables.get(4);
        this.C1Min_ = variables.get(5);
        this.C2Max_ = variables.get(6);
        this.C2Min_ = variables.get(7);
        this.WMax_ = variables.get(8);
        this.WMin_ = variables.get(9);
        this.ChVel1_ = variables.get(10);
        this.ChVel2_ = variables.get(11);
        this.hy_ = new Hypervolume();
        MetricsUtil mu = new MetricsUtil();
        this.trueFront_ = mu.readNonDominatedSolutionSet(trueParetoFront);
        this.trueHypervolume_ = this.hy_.hypervolume(this.trueFront_.writeObjectivesToMatrix(), this.trueFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
    }

    public void initParams() {
        this.swarmSize_ = (Integer)this.getInputParameter("swarmSize");
        this.maxIterations_ = (Integer)this.getInputParameter("maxIterations");
        this.maxAge_ = (Integer)this.getInputParameter("maxAge");
        this.indicators_ = (QualityIndicator)this.getInputParameter("indicators");
        String funcType = (String)this.getInputParameter("functionType");
        if (funcType != null && funcType != "") {
            this.functionType_ = funcType;
        }
        this.iteration_ = 0;
        this.particles_ = new SolutionSet(this.swarmSize_);
        this.lBest_ = new Solution[this.swarmSize_];
        this.gBest_ = new Solution[this.swarmSize_];
        this.shfGBest_ = new int[this.swarmSize_];
        this.speed_ = new double[this.swarmSize_][this.problem_.getNumberOfVariables()];
        this.age_ = new int[this.swarmSize_];
        this.deltaMax_ = new double[this.problem_.getNumberOfVariables()];
        this.deltaMin_ = new double[this.problem_.getNumberOfVariables()];
        for (int i = 0; i < this.problem_.getNumberOfVariables(); ++i) {
            this.deltaMax_[i] = (this.problem_.getUpperLimit(i) - this.problem_.getLowerLimit(i)) / 2.0;
            this.deltaMin_[i] = -this.deltaMax_[i];
        }
    }

    private double inertiaWeight(int iter, int miter, double wma, double wmin) {
        return wma;
    }

    private double constrictionCoefficient(double c1, double c2) {
        double rho = c1 + c2;
        if (rho <= 4.0) {
            return 1.0;
        }
        return 2.0 / (2.0 - rho - Math.sqrt(Math.pow(rho, 2.0) - 4.0 * rho));
    }

    private double velocityConstriction(double v, double[] deltaMax, double[] deltaMin, int variableIndex, int particleIndex) throws IOException {
        double dmax = deltaMax[variableIndex];
        double dmin = deltaMin[variableIndex];
        double result = v;
        if (v > dmax) {
            result = dmax;
        }
        if (v < dmin) {
            result = dmin;
        }
        return result;
    }

    private void computeSpeed(int i) throws JMException {
        XReal particle = new XReal(this.particles_.get(i));
        XReal bestParticle = new XReal(this.lBest_[i]);
        XReal bestGlobal = new XReal(this.gBest_[this.shfGBest_[i]]);
        double r1 = PseudoRandom.randDouble(this.r1Min_, this.r1Max_);
        double r2 = PseudoRandom.randDouble(this.r2Min_, this.r2Max_);
        double C1 = PseudoRandom.randDouble(this.C1Min_, this.C1Max_);
        double C2 = PseudoRandom.randDouble(this.C2Min_, this.C2Max_);
        double W = PseudoRandom.randDouble(this.WMin_, this.WMax_);
        double wmax = this.WMax_;
        double wmin = this.WMin_;
        for (int var = 0; var < particle.size(); ++var) {
            try {
                this.speed_[i][var] = this.velocityConstriction(this.constrictionCoefficient(C1, C2) * (this.inertiaWeight(this.iteration_, this.maxIterations_, wmax, wmin) * this.speed_[i][var] + C1 * r1 * (bestParticle.getValue(var) - particle.getValue(var)) + C2 * r2 * (bestGlobal.getValue(var) - particle.getValue(var))), this.deltaMax_, this.deltaMin_, var, i);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void computeNewPositions(int i) throws JMException {
        XReal particle = new XReal(this.particles_.get(i));
        for (int var = 0; var < particle.size(); ++var) {
            particle.setValue(var, particle.getValue(var) + this.speed_[i][var]);
        }
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        this.initParams();
        for (i = 0; i < this.swarmSize_; ++i) {
            Solution particle = new Solution(this.problem_);
            this.problem_.evaluate(particle);
            this.particles_.add(particle);
        }
        for (i = 0; i < this.swarmSize_; ++i) {
            for (int j = 0; j < this.problem_.getNumberOfVariables(); ++j) {
                this.speed_[i][j] = 0.0;
            }
            this.age_[i] = 0;
        }
        this.indArray_ = new Solution[this.problem_.getNumberOfObjectives()];
        this.z_ = new double[this.problem_.getNumberOfObjectives()];
        this.lambda_ = new double[this.swarmSize_][this.problem_.getNumberOfObjectives()];
        this.initUniformWeight();
        this.initIdealPoint();
        for (i = 0; i < this.particles_.size(); ++i) {
            Solution particle;
            this.lBest_[i] = particle = new Solution(this.particles_.get(i));
            this.gBest_[i] = particle;
        }
        this.updateGlobalBest();
        while (this.iteration_ < this.maxIterations_) {
            this.shuffleGlobalBest();
            for (i = 0; i < this.particles_.size(); ++i) {
                if (this.age_[i] < this.maxAge_) {
                    this.updateParticle(i);
                } else {
                    this.resetParticle(i);
                }
                this.repairBounds(i);
                this.problem_.evaluate(this.particles_.get(i));
                this.updateReference(this.particles_.get(i));
                this.updateLocalBest(i);
            }
            this.updateGlobalBest();
            ++this.iteration_;
        }
        SolutionSet ss = new SolutionSet(this.gBest_.length);
        for (int i2 = 0; i2 < this.gBest_.length; ++i2) {
            ss.add(this.gBest_[i2]);
        }
        return ss;
    }

    private void shuffleGlobalBest() {
        int i;
        int[] aux = new int[this.swarmSize_];
        for (i = 0; i < this.swarmSize_; ++i) {
            aux[i] = i;
        }
        for (i = 0; i < this.swarmSize_; ++i) {
            int rnd = PseudoRandom.randInt(i, this.swarmSize_ - 1);
            int tmp = aux[rnd];
            aux[rnd] = aux[i];
            this.shfGBest_[i] = tmp;
        }
    }

    private void repairBounds(int part) throws JMException {
        XReal particle = new XReal(this.particles_.get(part));
        for (int var = 0; var < particle.getNumberOfDecisionVariables(); ++var) {
            if (particle.getValue(var) < this.problem_.getLowerLimit(var)) {
                particle.setValue(var, this.problem_.getLowerLimit(var));
                this.speed_[part][var] = this.speed_[part][var] * this.ChVel1_;
            }
            if (!(particle.getValue(var) > this.problem_.getUpperLimit(var))) continue;
            particle.setValue(var, this.problem_.getUpperLimit(var));
            this.speed_[part][var] = this.speed_[part][var] * this.ChVel2_;
        }
    }

    private void resetParticle(int i) throws JMException {
        XReal particle = new XReal(this.particles_.get(i));
        for (int var = 0; var < particle.size(); ++var) {
            XReal gB = new XReal(this.gBest_[this.shfGBest_[i]]);
            XReal pB = new XReal(this.lBest_[i]);
            double mean = (gB.getValue(var) - pB.getValue(var)) / 2.0;
            double sigma = Math.abs(gB.getValue(var) - pB.getValue(var));
            Random rnd = new Random();
            double N = rnd.nextGaussian() * sigma + mean;
            particle.setValue(var, N);
            this.speed_[i][var] = 0.0;
        }
    }

    private void updateParticle(int i) throws JMException {
        this.computeSpeed(i);
        this.computeNewPositions(i);
    }

    private void initUniformWeight() {
        if (this.problem_.getNumberOfObjectives() == 2 && this.swarmSize_ < 300) {
            for (int n = 0; n < this.swarmSize_; ++n) {
                double a;
                this.lambda_[n][0] = a = 1.0 * (double)n / (double)(this.swarmSize_ - 1);
                this.lambda_[n][1] = 1.0 - a;
            }
        } else {
            this.dataDirectory_ = "/Users/antelverde/Softw/pruebas/data/MOEAD_parameters/Weight";
            String dataFileName = "W" + this.problem_.getNumberOfObjectives() + "D_" + this.swarmSize_ + ".dat";
            try {
                FileInputStream fis = new FileInputStream(this.dataDirectory_ + "/" + dataFileName);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                int i = 0;
                int j = 0;
                String aux = br.readLine();
                while (aux != null) {
                    StringTokenizer st = new StringTokenizer(aux);
                    j = 0;
                    while (st.hasMoreTokens()) {
                        double value;
                        this.lambda_[i][j] = value = new Double(st.nextToken()).doubleValue();
                        ++j;
                    }
                    aux = br.readLine();
                    ++i;
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("initUniformWeight: failed when reading for file: " + this.dataDirectory_ + "/" + dataFileName);
                e.printStackTrace();
            }
        }
    }

    private void initIdealPoint() throws JMException, ClassNotFoundException {
        int i;
        for (i = 0; i < this.problem_.getNumberOfObjectives(); ++i) {
            this.z_[i] = 1.0E30;
            this.indArray_[i] = new Solution(this.problem_);
            this.problem_.evaluate(this.indArray_[i]);
        }
        for (i = 0; i < this.swarmSize_; ++i) {
            this.updateReference(this.particles_.get(i));
        }
    }

    private void updateReference(Solution individual) {
        for (int n = 0; n < this.problem_.getNumberOfObjectives(); ++n) {
            if (!(individual.getObjective(n) < this.z_[n])) continue;
            this.z_[n] = individual.getObjective(n);
            this.indArray_[n] = new Solution(individual);
        }
    }

    private void updateGlobalBest() {
        for (int j = 0; j < this.lambda_.length; ++j) {
            double gBestFitness = this.fitnessFunction(this.gBest_[j], this.lambda_[j]);
            for (int i = 0; i < this.particles_.size(); ++i) {
                double v2;
                double v1 = this.fitnessFunction(this.particles_.get(i), this.lambda_[j]);
                if (!(v1 < (v2 = gBestFitness))) continue;
                this.gBest_[j] = new Solution(this.particles_.get(i));
                gBestFitness = v1;
            }
        }
    }

    private void updateLocalBest(int part) {
        Solution indiv = new Solution(this.particles_.get(part));
        double f1 = this.fitnessFunction(this.lBest_[part], this.lambda_[part]);
        double f2 = this.fitnessFunction(indiv, this.lambda_[part]);
        if (this.age_[part] >= this.maxAge_ || f2 <= f1) {
            this.lBest_[part] = indiv;
            this.age_[part] = 0;
        } else {
            int n = part;
            this.age_[n] = this.age_[n] + 1;
        }
    }

    private double fitnessFunction(Solution sol, double[] lambda) {
        double fitness = 0.0;
        if (this.functionType_.equals("_TCHE")) {
            double maxFun = -1.0E30;
            for (int n = 0; n < this.problem_.getNumberOfObjectives(); ++n) {
                double diff = Math.abs(sol.getObjective(n) - this.z_[n]);
                double feval = lambda[n] == 0.0 ? 1.0E-4 * diff : diff * lambda[n];
                if (!(feval > maxFun)) continue;
                maxFun = feval;
            }
            fitness = maxFun;
        } else if (this.functionType_.equals("_AGG")) {
            double sum = 0.0;
            for (int n = 0; n < this.problem_.getNumberOfObjectives(); ++n) {
                sum += lambda[n] * sol.getObjective(n);
            }
            fitness = sum;
        } else if (this.functionType_.equals("_PBI")) {
            int i;
            double theta = 5.0;
            double nl = 0.0;
            double d2 = 0.0;
            double d1 = 0.0;
            for (i = 0; i < this.problem_.getNumberOfObjectives(); ++i) {
                d1 += (sol.getObjective(i) - this.z_[i]) * lambda[i];
                nl += Math.pow(lambda[i], 2.0);
            }
            nl = Math.sqrt(nl);
            d1 = Math.abs(d1) / nl;
            for (i = 0; i < this.problem_.getNumberOfObjectives(); ++i) {
                d2 += Math.pow(sol.getObjective(i) - this.z_[i] - d1 * (lambda[i] / nl), 2.0);
            }
            d2 = Math.sqrt(d2);
            fitness = d1 + theta * d2;
        } else {
            System.out.println("dMOPSO.fitnessFunction: unknown type " + this.functionType_);
            System.exit(-1);
        }
        return fitness;
    }
}

