/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.dmopso;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.dmopso.dMOPSO;
import jmetal.problems.ProblemFactory;
import jmetal.problems.ZDT.ZDT1;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class dMOPSO_main {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, IOException, ClassNotFoundException {
        Problem problem;
        Object[] params;
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler("dMOPSO_main.log");
        logger_.addHandler(fileHandler_);
        QualityIndicator indicators = null;
        if (args.length == 1) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
        } else if (args.length == 2) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
            indicators = new QualityIndicator(problem, args[1]);
        } else {
            problem = new ZDT1("Real");
        }
        dMOPSO algorithm = new dMOPSO(problem);
        algorithm.setInputParameter("swarmSize", 100);
        algorithm.setInputParameter("maxAge", 2);
        algorithm.setInputParameter("maxIterations", 250);
        algorithm.setInputParameter("functionType", "_TCHE");
        HashMap parameters = new HashMap();
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        logger_.info("Total execution time: " + estimatedTime + "ms");
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
        if (indicators != null) {
            logger_.info("Quality indicators");
            logger_.info("Hypervolume: " + indicators.getHypervolume(population));
            logger_.info("GD         : " + indicators.getGD(population));
            logger_.info("IGD        : " + indicators.getIGD(population));
            logger_.info("Spread     : " + indicators.getSpread(population));
            logger_.info("Epsilon    : " + indicators.getEpsilon(population));
        }
    }
}

