/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.fastPGA;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.Distance;
import jmetal.util.FPGAFitness;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.FPGAFitnessComparator;

public class FastPGA
extends Algorithm {
    public FastPGA(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        Ranking ranking;
        SolutionSet candidateSolutionSet = null;
        Distance distance = new Distance();
        FPGAFitnessComparator fpgaFitnessComparator = new FPGAFitnessComparator();
        int maxPopSize = (Integer)this.getInputParameter("maxPopSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        int initialPopulationSize = (Integer)this.getInputParameter("initialPopulationSize");
        int termination = (Integer)this.getInputParameter("termination");
        Operator crossover = (Operator)this.operators_.get("crossover");
        Operator mutation = (Operator)this.operators_.get("mutation");
        Operator selection = (Operator)this.operators_.get("selection");
        double a = (Double)this.getInputParameter("a");
        double b = (Double)this.getInputParameter("b");
        double c = (Double)this.getInputParameter("c");
        double d = (Double)this.getInputParameter("d");
        int evaluations = 0;
        int populationSize = initialPopulationSize;
        int offSpringSize = maxPopSize;
        SolutionSet solutionSet = new SolutionSet(populationSize);
        for (int i = 0; i < populationSize; ++i) {
            Solution solution = new Solution(this.problem_);
            this.problem_.evaluate(solution);
            this.problem_.evaluateConstraints(solution);
            ++evaluations;
            solutionSet.add(solution);
        }
        Solution[] parents = new Solution[2];
        boolean stop = false;
        int reachesMaxNonDominated = 0;
        while (!stop) {
            SolutionSet offSpringSolutionSet = new SolutionSet(offSpringSize);
            for (int i = 0; i < offSpringSize / 2; ++i) {
                parents[0] = (Solution)selection.execute(solutionSet);
                parents[1] = (Solution)selection.execute(solutionSet);
                Solution[] offSprings = (Solution[])crossover.execute(parents);
                mutation.execute(offSprings[0]);
                mutation.execute(offSprings[1]);
                this.problem_.evaluate(offSprings[0]);
                this.problem_.evaluateConstraints(offSprings[0]);
                ++evaluations;
                this.problem_.evaluate(offSprings[1]);
                this.problem_.evaluateConstraints(offSprings[1]);
                ++evaluations;
                offSpringSolutionSet.add(offSprings[0]);
                offSpringSolutionSet.add(offSprings[1]);
            }
            candidateSolutionSet = solutionSet.union(offSpringSolutionSet);
            ranking = new Ranking(candidateSolutionSet);
            distance.crowdingDistanceAssignment(ranking.getSubfront(0), this.problem_.getNumberOfObjectives());
            FPGAFitness fitness = new FPGAFitness(candidateSolutionSet, this.problem_);
            fitness.fitnessAssign();
            int count = ranking.getSubfront(0).size();
            populationSize = (int)Math.min(a + Math.floor(b * (double)count), (double)maxPopSize);
            offSpringSize = (int)Math.min(c + Math.floor(d * (double)count), (double)maxPopSize);
            candidateSolutionSet.sort(fpgaFitnessComparator);
            solutionSet = new SolutionSet(populationSize);
            for (int i = 0; i < populationSize; ++i) {
                solutionSet.add(candidateSolutionSet.get(i));
            }
            if (termination == 0) {
                ranking = new Ranking(solutionSet);
                count = ranking.getSubfront(0).size();
                if (count == maxPopSize) {
                    if (reachesMaxNonDominated == 0) {
                        reachesMaxNonDominated = evaluations;
                    }
                    if (evaluations - reachesMaxNonDominated < maxEvaluations) continue;
                    stop = true;
                    continue;
                }
                reachesMaxNonDominated = 0;
                continue;
            }
            if (evaluations < maxEvaluations) continue;
            stop = true;
        }
        this.setOutputParameter("evaluations", evaluations);
        ranking = new Ranking(solutionSet);
        return ranking.getSubfront(0);
    }
}

