/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.fastPGA;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.fastPGA.FastPGA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.BinaryTournament;
import jmetal.problems.Kursawe;
import jmetal.problems.ProblemFactory;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.comparators.FPGAFitnessComparator;

public class FastPGA_main {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, IOException, ClassNotFoundException {
        Problem problem;
        Object[] params;
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler("FastPGA_main.log");
        logger_.addHandler(fileHandler_);
        QualityIndicator indicators = null;
        if (args.length == 1) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
        } else if (args.length == 2) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
            indicators = new QualityIndicator(problem, args[1]);
        } else {
            problem = new Kursawe("Real", 3);
        }
        FastPGA algorithm = new FastPGA(problem);
        algorithm.setInputParameter("maxPopSize", 100);
        algorithm.setInputParameter("initialPopulationSize", 100);
        algorithm.setInputParameter("maxEvaluations", 25000);
        algorithm.setInputParameter("a", 20.0);
        algorithm.setInputParameter("b", 1.0);
        algorithm.setInputParameter("c", 20.0);
        algorithm.setInputParameter("d", 0.0);
        algorithm.setInputParameter("termination", 1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", 0.9);
        parameters.put("distributionIndex", 20.0);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 1.0 / (double)problem.getNumberOfVariables());
        parameters.put("distributionIndex", 20.0);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        parameters = new HashMap();
        parameters.put("comparator", new FPGAFitnessComparator());
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        logger_.info("Total execution time: " + estimatedTime + "ms");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        if (indicators != null) {
            logger_.info("Quality indicators");
            logger_.info("Hypervolume: " + indicators.getHypervolume(population));
            logger_.info("GD         : " + indicators.getGD(population));
            logger_.info("IGD        : " + indicators.getIGD(population));
            logger_.info("Spread     : " + indicators.getSpread(population));
            logger_.info("Epsilon    : " + indicators.getEpsilon(population));
            int evaluations = (Integer)algorithm.getOutputParameter("evaluations");
            logger_.info("Speed      : " + evaluations + " evaluations");
        }
    }
}

