/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.gde3;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.CrowdingComparator;
import jmetal.util.comparators.DominanceComparator;

public class GDE3
extends Algorithm {
    public GDE3(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        Distance distance = new Distance();
        DominanceComparator dominance = new DominanceComparator();
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxIterations = (Integer)this.getInputParameter("maxIterations");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        SolutionSet population = new SolutionSet(populationSize);
        int evaluations = 0;
        int iterations = 0;
        for (i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            this.problem_.evaluateConstraints(newSolution);
            ++evaluations;
            population.add(newSolution);
        }
        while (iterations < maxIterations) {
            int k;
            SolutionSet offspringPopulation = new SolutionSet(populationSize * 2);
            for (i = 0; i < populationSize; ++i) {
                Solution[] parent = (Solution[])selectionOperator.execute(new Object[]{population, i});
                Solution child = (Solution)crossoverOperator.execute(new Object[]{population.get(i), parent});
                this.problem_.evaluate(child);
                this.problem_.evaluateConstraints(child);
                ++evaluations;
                int result = dominance.compare(population.get(i), child);
                if (result == -1) {
                    offspringPopulation.add(population.get(i));
                    continue;
                }
                if (result == 1) {
                    offspringPopulation.add(child);
                    continue;
                }
                offspringPopulation.add(child);
                offspringPopulation.add(population.get(i));
            }
            Ranking ranking = new Ranking(offspringPopulation);
            int remain = populationSize;
            int index = 0;
            SolutionSet front = null;
            population.clear();
            front = ranking.getSubfront(index);
            while (remain > 0 && remain >= front.size()) {
                distance.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
                for (k = 0; k < front.size(); ++k) {
                    population.add(front.get(k));
                }
                ++index;
                if ((remain -= front.size()) <= 0) continue;
                front = ranking.getSubfront(index);
            }
            if (remain > 0) {
                while (front.size() > remain) {
                    distance.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
                    front.remove(front.indexWorst(new CrowdingComparator()));
                }
                for (k = 0; k < front.size(); ++k) {
                    population.add(front.get(k));
                }
                remain = 0;
            }
            ++iterations;
        }
        Ranking ranking = new Ranking(population);
        return ranking.getSubfront(0);
    }
}

