/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.moead;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.moead.Utils;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class pMOEAD
extends Algorithm
implements Runnable {
    private int populationSize_;
    private SolutionSet population_;
    private int numberOfThreads_;
    double[] z_;
    double[][] lambda_;
    int T_;
    int[][] neighborhood_;
    double delta_;
    int nr_;
    Solution[] indArray_;
    String functionType_;
    int evaluations_;
    int maxEvaluations_;
    Operator crossover_;
    Operator mutation_;
    int id_;
    public HashMap<String, Object> map_;
    pMOEAD parentThread_;
    Thread[] thread_;
    String dataDirectory_;
    CyclicBarrier barrier_;
    long initTime_;

    public pMOEAD(Problem problem) {
        super(problem);
        this.parentThread_ = null;
        this.functionType_ = "_TCHE1";
        this.id_ = 0;
    }

    public pMOEAD(pMOEAD parentThread, Problem problem, int id, int numberOfThreads) {
        super(problem);
        this.parentThread_ = parentThread;
        this.numberOfThreads_ = numberOfThreads;
        this.thread_ = new Thread[this.numberOfThreads_];
        this.functionType_ = "_TCHE1";
        this.id_ = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.neighborhood_ = this.parentThread_.neighborhood_;
        this.problem_ = this.parentThread_.problem_;
        this.lambda_ = this.parentThread_.lambda_;
        this.population_ = this.parentThread_.population_;
        this.z_ = this.parentThread_.z_;
        this.indArray_ = this.parentThread_.indArray_;
        this.barrier_ = this.parentThread_.barrier_;
        int partitions = this.parentThread_.populationSize_ / this.parentThread_.numberOfThreads_;
        this.evaluations_ = 0;
        this.maxEvaluations_ = this.parentThread_.maxEvaluations_ / this.parentThread_.numberOfThreads_;
        try {
            this.barrier_.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
        int first = partitions * this.id_;
        int last = this.id_ == this.parentThread_.numberOfThreads_ - 1 ? this.parentThread_.populationSize_ - 1 : first + partitions - 1;
        System.out.println("Id: " + this.id_ + "  Partitions: " + partitions + " First: " + first + " Last: " + last);
        do {
            for (int i = first; i <= last; ++i) {
                int n = i;
                double rnd = PseudoRandom.randDouble();
                int type = rnd < this.parentThread_.delta_ ? 1 : 2;
                Vector<Integer> p = new Vector<Integer>();
                this.matingSelection(p, n, 2, type);
                Solution child = null;
                Solution[] parents = new Solution[3];
                try {
                    pMOEAD pMOEAD2 = this.parentThread_;
                    synchronized (pMOEAD2) {
                        parents[0] = this.parentThread_.population_.get(p.get(0));
                        parents[1] = this.parentThread_.population_.get(p.get(1));
                        parents[2] = this.parentThread_.population_.get(n);
                        child = (Solution)this.parentThread_.crossover_.execute(new Object[]{this.parentThread_.population_.get(n), parents});
                    }
                    this.parentThread_.mutation_.execute(child);
                    this.parentThread_.problem_.evaluate(child);
                }
                catch (JMException ex) {
                    Logger.getLogger(pMOEAD.class.getName()).log(Level.SEVERE, null, ex);
                }
                ++this.evaluations_;
                this.updateReference(child);
                this.updateOfSolutions(child, n, type);
            }
        } while (this.evaluations_ < this.maxEvaluations_);
        long estimatedTime = System.currentTimeMillis() - this.parentThread_.initTime_;
        System.out.println("Time thread " + this.id_ + ": " + estimatedTime);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        this.parentThread_ = this;
        this.evaluations_ = 0;
        this.maxEvaluations_ = (Integer)this.getInputParameter("maxEvaluations");
        this.populationSize_ = (Integer)this.getInputParameter("populationSize");
        this.dataDirectory_ = this.getInputParameter("dataDirectory").toString();
        this.numberOfThreads_ = (Integer)this.getInputParameter("numberOfThreads");
        this.thread_ = new Thread[this.numberOfThreads_];
        this.barrier_ = new CyclicBarrier(this.numberOfThreads_);
        this.population_ = new SolutionSet(this.populationSize_);
        this.indArray_ = new Solution[this.problem_.getNumberOfObjectives()];
        this.T_ = (Integer)this.getInputParameter("T");
        this.nr_ = (Integer)this.getInputParameter("nr");
        this.delta_ = (Double)this.getInputParameter("delta");
        this.neighborhood_ = new int[this.populationSize_][this.T_];
        this.z_ = new double[this.problem_.getNumberOfObjectives()];
        this.lambda_ = new double[this.populationSize_][this.problem_.getNumberOfObjectives()];
        this.crossover_ = (Operator)this.operators_.get("crossover");
        this.mutation_ = (Operator)this.operators_.get("mutation");
        this.initUniformWeight();
        this.initNeighborhood();
        this.initPopulation();
        this.initIdealPoint();
        this.initTime_ = System.currentTimeMillis();
        for (i = 0; i < this.numberOfThreads_; ++i) {
            this.thread_[i] = new Thread((Runnable)new pMOEAD(this, this.problem_, i, this.numberOfThreads_), "pepe");
            this.thread_[i].start();
        }
        for (i = 0; i < this.numberOfThreads_; ++i) {
            try {
                this.thread_[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(pMOEAD.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.population_;
    }

    public void initNeighborhood() {
        double[] x = new double[this.populationSize_];
        int[] idx = new int[this.populationSize_];
        for (int i = 0; i < this.populationSize_; ++i) {
            for (int j = 0; j < this.populationSize_; ++j) {
                x[j] = Utils.distVector(this.lambda_[i], this.lambda_[j]);
                idx[j] = j;
            }
            Utils.minFastSort(x, idx, this.populationSize_, this.T_);
            for (int k = 0; k < this.T_; ++k) {
                this.neighborhood_[i][k] = idx[k];
            }
        }
    }

    public void initUniformWeight() {
        if (this.problem_.getNumberOfObjectives() == 2 && this.populationSize_ < 300) {
            for (int n = 0; n < this.populationSize_; ++n) {
                double a;
                this.lambda_[n][0] = a = 1.0 * (double)n / (double)(this.populationSize_ - 1);
                this.lambda_[n][1] = 1.0 - a;
            }
        } else {
            String dataFileName = "W" + this.problem_.getNumberOfObjectives() + "D_" + this.populationSize_ + ".dat";
            System.out.println(this.dataDirectory_);
            System.out.println(this.dataDirectory_ + "/" + dataFileName);
            try {
                FileInputStream fis = new FileInputStream(this.dataDirectory_ + "/" + dataFileName);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                int numberOfObjectives = 0;
                int i = 0;
                int j = 0;
                String aux = br.readLine();
                while (aux != null) {
                    StringTokenizer st = new StringTokenizer(aux);
                    j = 0;
                    numberOfObjectives = st.countTokens();
                    while (st.hasMoreTokens()) {
                        double value;
                        this.lambda_[i][j] = value = new Double(st.nextToken()).doubleValue();
                        ++j;
                    }
                    aux = br.readLine();
                    ++i;
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("initUniformWeight: fail when reading for file: " + this.dataDirectory_ + "/" + dataFileName);
                e.printStackTrace();
            }
        }
    }

    public void initPopulation() throws JMException, ClassNotFoundException {
        for (int i = 0; i < this.populationSize_; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            ++this.evaluations_;
            this.population_.add(newSolution);
        }
    }

    void initIdealPoint() throws JMException, ClassNotFoundException {
        int i;
        for (i = 0; i < this.problem_.getNumberOfObjectives(); ++i) {
            this.z_[i] = 1.0E30;
            this.indArray_[i] = new Solution(this.problem_);
            this.problem_.evaluate(this.indArray_[i]);
            ++this.evaluations_;
        }
        for (i = 0; i < this.populationSize_; ++i) {
            this.updateReference(this.population_.get(i));
        }
    }

    public void matingSelection(Vector<Integer> list, int cid, int size, int type) {
        int ss = this.parentThread_.neighborhood_[cid].length;
        while (list.size() < size) {
            int p;
            if (type == 1) {
                int r = PseudoRandom.randInt(0, ss - 1);
                p = this.parentThread_.neighborhood_[cid][r];
            } else {
                p = PseudoRandom.randInt(0, this.parentThread_.populationSize_ - 1);
            }
            boolean flag = true;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != p) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            list.addElement(p);
        }
    }

    synchronized void updateReference(Solution individual) {
        for (int n = 0; n < this.parentThread_.problem_.getNumberOfObjectives(); ++n) {
            if (!(individual.getObjective(n) < this.z_[n])) continue;
            this.parentThread_.z_[n] = individual.getObjective(n);
            this.parentThread_.indArray_[n] = individual;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateOfSolutions(Solution indiv, int id, int type) {
        int time = 0;
        int size = type == 1 ? this.parentThread_.neighborhood_[id].length : this.parentThread_.population_.size();
        int[] perm = new int[size];
        Utils.randomPermutation(perm, size);
        for (int i = 0; i < size; ++i) {
            int k = type == 1 ? this.parentThread_.neighborhood_[id][perm[i]] : perm[i];
            double f2 = this.fitnessFunction(indiv, this.parentThread_.lambda_[k]);
            pMOEAD pMOEAD2 = this.parentThread_;
            synchronized (pMOEAD2) {
                double f1 = this.fitnessFunction(this.parentThread_.population_.get(k), this.parentThread_.lambda_[k]);
                if (f2 < f1) {
                    this.parentThread_.population_.replace(k, new Solution(indiv));
                    ++time;
                }
            }
            if (time < this.parentThread_.nr_) continue;
            return;
        }
    }

    double fitnessFunction(Solution individual, double[] lambda) {
        double fitness = 0.0;
        if (this.parentThread_.functionType_.equals("_TCHE1")) {
            double maxFun = -1.0E30;
            for (int n = 0; n < this.parentThread_.problem_.getNumberOfObjectives(); ++n) {
                double diff = Math.abs(individual.getObjective(n) - this.z_[n]);
                double feval = lambda[n] == 0.0 ? 1.0E-4 * diff : diff * lambda[n];
                if (!(feval > maxFun)) continue;
                maxFun = feval;
            }
            fitness = maxFun;
        } else {
            System.out.println("MOEAD.fitnessFunction: unknown type " + this.functionType_);
            System.exit(-1);
        }
        return fitness;
    }
}

