/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.nsgaII;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.CrowdingComparator;

public class NSGAII
extends Algorithm {
    public NSGAII(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        Distance distance = new Distance();
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        QualityIndicator indicators = (QualityIndicator)this.getInputParameter("indicators");
        SolutionSet population = new SolutionSet(populationSize);
        int evaluations = 0;
        int requiredEvaluations = 0;
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        for (int i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            this.problem_.evaluateConstraints(newSolution);
            ++evaluations;
            population.add(newSolution);
        }
        while (evaluations < maxEvaluations) {
            double HV;
            int k;
            SolutionSet offspringPopulation = new SolutionSet(populationSize);
            Solution[] parents = new Solution[2];
            for (int i = 0; i < populationSize / 2; ++i) {
                if (evaluations >= maxEvaluations) continue;
                parents[0] = (Solution)selectionOperator.execute(population);
                parents[1] = (Solution)selectionOperator.execute(population);
                Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offSpring[0]);
                mutationOperator.execute(offSpring[1]);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[0]);
                this.problem_.evaluate(offSpring[1]);
                this.problem_.evaluateConstraints(offSpring[1]);
                offspringPopulation.add(offSpring[0]);
                offspringPopulation.add(offSpring[1]);
                evaluations += 2;
            }
            SolutionSet union = population.union(offspringPopulation);
            Ranking ranking = new Ranking(union);
            int remain = populationSize;
            int index = 0;
            SolutionSet front = null;
            population.clear();
            front = ranking.getSubfront(index);
            while (remain > 0 && remain >= front.size()) {
                distance.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
                for (k = 0; k < front.size(); ++k) {
                    population.add(front.get(k));
                }
                ++index;
                if ((remain -= front.size()) <= 0) continue;
                front = ranking.getSubfront(index);
            }
            if (remain > 0) {
                distance.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
                front.sort(new CrowdingComparator());
                for (k = 0; k < remain; ++k) {
                    population.add(front.get(k));
                }
                remain = 0;
            }
            if (indicators == null || requiredEvaluations != 0 || !((HV = indicators.getHypervolume(population)) >= 0.98 * indicators.getTrueParetoFrontHypervolume())) continue;
            requiredEvaluations = evaluations;
        }
        this.setOutputParameter("evaluations", requiredEvaluations);
        Ranking ranking = new Ranking(population);
        ranking.getSubfront(0).printFeasibleFUN("FUN_NSGAII");
        return ranking.getSubfront(0);
    }
}

