/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.nsgaII;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.Ranking;
import jmetal.util.comparators.CrowdingComparator;
import jmetal.util.offspring.Offspring;
import jmetal.util.offspring.PolynomialMutationOffspring;

public class NSGAIIRandom
extends Algorithm {
    public int populationSize_;
    public SolutionSet population_;
    public SolutionSet offspringPopulation_;
    public SolutionSet union_;
    int maxEvaluations_;
    int evaluations_;
    int[] contributionCounter_;
    double[] contribution_;
    double total = 0.0;
    Operator selectionOperator_;

    public NSGAIIRandom(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        double[] contrReal = new double[3];
        contrReal[2] = 0.0;
        contrReal[1] = 0.0;
        contrReal[0] = 0.0;
        Distance distance = new Distance();
        this.populationSize_ = (Integer)this.getInputParameter("populationSize");
        this.maxEvaluations_ = (Integer)this.getInputParameter("maxEvaluations");
        this.population_ = new SolutionSet(this.populationSize_);
        this.evaluations_ = 0;
        this.selectionOperator_ = (Operator)this.operators_.get("selection");
        Offspring[] getOffspring = (Offspring[])this.getInputParameter("offspringsCreators");
        int N_O = getOffspring.length;
        this.contribution_ = new double[N_O];
        this.contributionCounter_ = new int[N_O];
        this.contribution_[0] = (double)this.populationSize_ / (double)N_O / (double)this.populationSize_;
        for (i = 1; i < N_O; ++i) {
            this.contribution_[i] = (double)this.populationSize_ / (double)N_O / (double)this.populationSize_ + this.contribution_[i - 1];
        }
        for (i = 0; i < N_O; ++i) {
            System.out.println(getOffspring[i].configuration());
            System.out.println("Contribution: " + this.contribution_[i]);
        }
        for (int i2 = 0; i2 < this.populationSize_; ++i2) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            this.problem_.evaluateConstraints(newSolution);
            ++this.evaluations_;
            newSolution.setLocation(i2);
            this.population_.add(newSolution);
        }
        while (this.evaluations_ < this.maxEvaluations_) {
            this.offspringPopulation_ = new SolutionSet(this.populationSize_);
            Solution[] parents = new Solution[2];
            for (int i3 = 0; i3 < this.populationSize_ / 1; ++i3) {
                if (this.evaluations_ >= this.maxEvaluations_) continue;
                Solution individual = new Solution(this.population_.get(PseudoRandom.randInt(0, this.populationSize_ - 1)));
                int selected = 0;
                boolean found = false;
                Solution offSpring = null;
                double rnd = PseudoRandom.randDouble();
                for (selected = 0; selected < N_O; ++selected) {
                    if (found || !(rnd <= this.contribution_[selected])) continue;
                    if ("DE".equals(getOffspring[selected].id())) {
                        offSpring = getOffspring[selected].getOffspring(this.population_, i3);
                    } else if ("SBXCrossover".equals(getOffspring[selected].id())) {
                        offSpring = getOffspring[selected].getOffspring(this.population_);
                    } else if ("PolynomialMutation".equals(getOffspring[selected].id())) {
                        offSpring = ((PolynomialMutationOffspring)getOffspring[selected]).getOffspring(individual);
                    } else {
                        System.out.println("Error in NSGAIIAdaptive. Operator " + offSpring + " does not exist");
                    }
                    offSpring.setFitness(selected);
                    found = true;
                }
                this.problem_.evaluate(offSpring);
                this.offspringPopulation_.add(offSpring);
                ++this.evaluations_;
            }
            this.union_ = this.population_.union(this.offspringPopulation_);
            Ranking ranking = new Ranking(this.union_);
            int remain = this.populationSize_;
            int index = 0;
            SolutionSet front = null;
            this.population_.clear();
            front = ranking.getSubfront(index);
            while (remain > 0 && remain >= front.size()) {
                distance.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
                for (int k = 0; k < front.size(); ++k) {
                    this.population_.add(front.get(k));
                }
                ++index;
                if ((remain -= front.size()) <= 0) continue;
                front = ranking.getSubfront(index);
            }
            if (remain <= 0) continue;
            distance.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
            front.sort(new CrowdingComparator());
            for (int k = 0; k < remain; ++k) {
                this.population_.add(front.get(k));
            }
        }
        Ranking ranking = new Ranking(this.population_);
        return ranking.getSubfront(0);
    }
}

