/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.nsgaII;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.nsgaII.NSGAII;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.mTSP;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class NSGAII_mTSP_main {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, SecurityException, IOException, ClassNotFoundException {
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler("NSGAII_main.log");
        logger_.addHandler(fileHandler_);
        QualityIndicator indicators = null;
        mTSP problem = new mTSP("Permutation", "kroA150.tsp", "kroB150.tsp");
        NSGAII algorithm = new NSGAII(problem);
        algorithm.setInputParameter("populationSize", 100);
        algorithm.setInputParameter("maxEvaluations", 10000000);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", 0.95);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("PMXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 0.2);
        Mutation mutation = MutationFactory.getMutationOperator("SwapMutation", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        algorithm.setInputParameter("indicators", indicators);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        logger_.info("Total execution time: " + estimatedTime + "ms");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        if (indicators != null) {
            logger_.info("Quality indicators");
            logger_.info("Hypervolume: " + indicators.getHypervolume(population));
            logger_.info("GD         : " + indicators.getGD(population));
            logger_.info("IGD        : " + indicators.getIGD(population));
            logger_.info("Spread     : " + indicators.getSpread(population));
            logger_.info("Epsilon    : " + indicators.getEpsilon(population));
            int evaluations = (Integer)algorithm.getOutputParameter("evaluations");
            logger_.info("Speed      : " + evaluations + " evaluations");
        }
    }
}

