/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.nsgaII;

import java.util.List;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.CrowdingComparator;
import jmetal.util.parallel.IParallelEvaluator;

public class pNSGAII
extends Algorithm {
    IParallelEvaluator parallelEvaluator_;

    public pNSGAII(Problem problem, IParallelEvaluator evaluator) {
        super(problem);
        this.parallelEvaluator_ = evaluator;
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        Distance distance = new Distance();
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        QualityIndicator indicators = (QualityIndicator)this.getInputParameter("indicators");
        this.parallelEvaluator_.startEvaluator(this.problem_);
        SolutionSet population = new SolutionSet(populationSize);
        int evaluations = 0;
        int requiredEvaluations = 0;
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        for (int i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.parallelEvaluator_.addSolutionForEvaluation(newSolution);
        }
        List<Solution> solutionList = this.parallelEvaluator_.parallelEvaluation();
        for (Solution solution : solutionList) {
            population.add(solution);
            ++evaluations;
        }
        while (evaluations < maxEvaluations) {
            double HV;
            int k;
            SolutionSet offspringPopulation = new SolutionSet(populationSize);
            Solution[] parents = new Solution[2];
            for (int i = 0; i < populationSize / 2; ++i) {
                if (evaluations >= maxEvaluations) continue;
                parents[0] = (Solution)selectionOperator.execute(population);
                parents[1] = (Solution)selectionOperator.execute(population);
                Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offSpring[0]);
                mutationOperator.execute(offSpring[1]);
                this.parallelEvaluator_.addSolutionForEvaluation(offSpring[0]);
                this.parallelEvaluator_.addSolutionForEvaluation(offSpring[1]);
            }
            List<Solution> solutions = this.parallelEvaluator_.parallelEvaluation();
            for (Solution solution : solutions) {
                offspringPopulation.add(solution);
                ++evaluations;
            }
            SolutionSet union = population.union(offspringPopulation);
            Ranking ranking = new Ranking(union);
            int remain = populationSize;
            int index = 0;
            SolutionSet front = null;
            population.clear();
            front = ranking.getSubfront(index);
            while (remain > 0 && remain >= front.size()) {
                distance.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
                for (k = 0; k < front.size(); ++k) {
                    population.add(front.get(k));
                }
                ++index;
                if ((remain -= front.size()) <= 0) continue;
                front = ranking.getSubfront(index);
            }
            if (remain > 0) {
                distance.crowdingDistanceAssignment(front, this.problem_.getNumberOfObjectives());
                front.sort(new CrowdingComparator());
                for (k = 0; k < remain; ++k) {
                    population.add(front.get(k));
                }
                remain = 0;
            }
            if (indicators == null || requiredEvaluations != 0 || !((HV = indicators.getHypervolume(population)) >= 0.98 * indicators.getTrueParetoFrontHypervolume())) continue;
            requiredEvaluations = evaluations;
        }
        this.parallelEvaluator_.stopEvaluator();
        this.setOutputParameter("evaluations", requiredEvaluations);
        Ranking ranking = new Ranking(population);
        return ranking.getSubfront(0);
    }
}

