/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.omopso;

import java.util.Comparator;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.core.Variable;
import jmetal.operators.mutation.Mutation;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.NonDominatedSolutionList;
import jmetal.util.PseudoRandom;
import jmetal.util.archive.CrowdingArchive;
import jmetal.util.comparators.CrowdingDistanceComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.EpsilonDominanceComparator;

public class OMOPSO
extends Algorithm {
    private int particlesSize_;
    private int archiveSize_;
    private int maxIterations_;
    private int iteration_;
    private double perturbation_;
    private SolutionSet particles_;
    private Solution[] best_;
    private CrowdingArchive leaders_;
    private NonDominatedSolutionList eArchive_;
    private double[][] speed_;
    private Comparator dominance_;
    private Comparator crowdingDistanceComparator_;
    private Distance distance_;
    private Operator uniformMutation_;
    private Operator nonUniformMutation_;
    private double eta_ = 0.0075;

    public OMOPSO(Problem problem) {
        super(problem);
    }

    public void initParams() {
        this.particlesSize_ = (Integer)this.getInputParameter("swarmSize");
        this.archiveSize_ = (Integer)this.getInputParameter("archiveSize");
        this.maxIterations_ = (Integer)this.getInputParameter("maxIterations");
        this.particles_ = new SolutionSet(this.particlesSize_);
        this.best_ = new Solution[this.particlesSize_];
        this.leaders_ = new CrowdingArchive(this.archiveSize_, this.problem_.getNumberOfObjectives());
        this.eArchive_ = new NonDominatedSolutionList(new EpsilonDominanceComparator(this.eta_));
        this.uniformMutation_ = (Mutation)this.operators_.get("uniformMutation");
        this.nonUniformMutation_ = (Mutation)this.operators_.get("nonUniformMutation");
        this.dominance_ = new DominanceComparator();
        this.crowdingDistanceComparator_ = new CrowdingDistanceComparator();
        this.distance_ = new Distance();
        this.speed_ = new double[this.particlesSize_][this.problem_.getNumberOfVariables()];
    }

    private void computeSpeed() throws JMException {
        for (int i = 0; i < this.particlesSize_; ++i) {
            Solution two;
            Variable[] particle = this.particles_.get(i).getDecisionVariables();
            Variable[] bestParticle = this.best_[i].getDecisionVariables();
            int pos1 = PseudoRandom.randInt(0, this.leaders_.size() - 1);
            int pos2 = PseudoRandom.randInt(0, this.leaders_.size() - 1);
            Solution one = this.leaders_.get(pos1);
            Variable[] bestGlobal = this.crowdingDistanceComparator_.compare(one, two = this.leaders_.get(pos2)) < 1 ? one.getDecisionVariables() : two.getDecisionVariables();
            double r1 = PseudoRandom.randDouble();
            double r2 = PseudoRandom.randDouble();
            double C1 = PseudoRandom.randDouble(1.5, 2.0);
            double C2 = PseudoRandom.randDouble(1.5, 2.0);
            double W = PseudoRandom.randDouble(0.1, 0.5);
            for (int var = 0; var < particle.length; ++var) {
                this.speed_[i][var] = W * this.speed_[i][var] + C1 * r1 * (bestParticle[var].getValue() - particle[var].getValue()) + C2 * r2 * (bestGlobal[var].getValue() - particle[var].getValue());
            }
        }
    }

    private void computeNewPositions() throws JMException {
        for (int i = 0; i < this.particlesSize_; ++i) {
            Variable[] particle = this.particles_.get(i).getDecisionVariables();
            for (int var = 0; var < particle.length; ++var) {
                particle[var].setValue(particle[var].getValue() + this.speed_[i][var]);
                if (particle[var].getValue() < this.problem_.getLowerLimit(var)) {
                    particle[var].setValue(this.problem_.getLowerLimit(var));
                    this.speed_[i][var] = this.speed_[i][var] * -1.0;
                }
                if (!(particle[var].getValue() > this.problem_.getUpperLimit(var))) continue;
                particle[var].setValue(this.problem_.getUpperLimit(var));
                this.speed_[i][var] = this.speed_[i][var] * -1.0;
            }
        }
    }

    private void mopsoMutation(int actualIteration, int totalIterations) throws JMException {
        this.nonUniformMutation_.setParameter("currentIteration", actualIteration);
        for (int i = 0; i < this.particles_.size(); ++i) {
            if (i % 3 == 0) {
                this.nonUniformMutation_.execute(this.particles_.get(i));
                continue;
            }
            if (i % 3 != 1) continue;
            this.uniformMutation_.execute(this.particles_.get(i));
        }
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        this.initParams();
        for (i = 0; i < this.particlesSize_; ++i) {
            Solution particle = new Solution(this.problem_);
            this.problem_.evaluate(particle);
            this.problem_.evaluateConstraints(particle);
            this.particles_.add(particle);
        }
        for (i = 0; i < this.particlesSize_; ++i) {
            for (int j = 0; j < this.problem_.getNumberOfVariables(); ++j) {
                this.speed_[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.particles_.size(); ++i) {
            Solution particle = new Solution(this.particles_.get(i));
            if (!this.leaders_.add(particle)) continue;
            this.eArchive_.add(new Solution(particle));
        }
        for (i = 0; i < this.particles_.size(); ++i) {
            Solution particle;
            this.best_[i] = particle = new Solution(this.particles_.get(i));
        }
        this.distance_.crowdingDistanceAssignment(this.leaders_, this.problem_.getNumberOfObjectives());
        while (this.iteration_ < this.maxIterations_) {
            this.computeSpeed();
            this.computeNewPositions();
            this.mopsoMutation(this.iteration_, this.maxIterations_);
            for (i = 0; i < this.particles_.size(); ++i) {
                Solution particle = this.particles_.get(i);
                this.problem_.evaluate(particle);
                this.problem_.evaluateConstraints(particle);
            }
            for (i = 0; i < this.particles_.size(); ++i) {
                Solution particle = new Solution(this.particles_.get(i));
                if (!this.leaders_.add(particle)) continue;
                this.eArchive_.add(new Solution(particle));
            }
            for (i = 0; i < this.particles_.size(); ++i) {
                Solution particle;
                int flag = this.dominance_.compare(this.particles_.get(i), this.best_[i]);
                if (flag == 1) continue;
                this.best_[i] = particle = new Solution(this.particles_.get(i));
            }
            this.distance_.crowdingDistanceAssignment(this.leaders_, this.problem_.getNumberOfObjectives());
            ++this.iteration_;
        }
        return this.leaders_;
    }

    public SolutionSet getLeader() {
        return this.leaders_;
    }
}

