/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.cmaes;

import java.util.Comparator;
import java.util.Random;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.core.Variable;
import jmetal.metaheuristics.singleObjective.cmaes.Utils;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.comparators.ObjectiveComparator;

public class CMAES
extends Algorithm {
    private int populationSize;
    private int counteval;
    private int maxEvaluations;
    private double sigma;
    private double[] xmean;
    private double[] xold;
    private int mu;
    private double[] weights;
    private double mueff;
    private double cc;
    private double cs;
    private double c1;
    private double cmu;
    private double damps;
    private double[] pc;
    private double[] ps;
    private double[][] B;
    private double[] diagD;
    private double[][] C;
    private double[][] invsqrtC;
    private int eigeneval;
    private double chiN;
    private double[][] arx;
    private SolutionSet population_;
    private Solution bestSolutionEver = null;
    private Random rand;

    public CMAES(Problem problem) {
        super(problem);
        long seed = System.currentTimeMillis();
        this.rand = new Random(seed);
    }

    private void init() throws ClassNotFoundException {
        int i;
        int i2;
        int N = this.problem_.getNumberOfVariables();
        this.xmean = new double[N];
        for (int i3 = 0; i3 < N; ++i3) {
            this.xmean[i3] = PseudoRandom.randDouble(0.0, 1.0);
        }
        this.sigma = 0.3;
        int lambda = this.populationSize;
        this.mu = (int)Math.floor(lambda / 2);
        this.weights = new double[this.mu];
        double sum = 0.0;
        for (i2 = 0; i2 < this.mu; ++i2) {
            this.weights[i2] = Math.log(this.mu + 0) - Math.log(i2 + 1);
            sum += this.weights[i2];
        }
        for (i2 = 0; i2 < this.mu; ++i2) {
            this.weights[i2] = this.weights[i2] / sum;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (i = 0; i < this.mu; ++i) {
            sum1 += this.weights[i];
            sum2 += this.weights[i] * this.weights[i];
        }
        this.mueff = sum1 * sum1 / sum2;
        this.cc = (4.0 + this.mueff / (double)N) / ((double)(N + 4) + 2.0 * this.mueff / (double)N);
        this.cs = (this.mueff + 2.0) / ((double)N + this.mueff + 5.0);
        this.c1 = 2.0 / (((double)N + 1.3) * ((double)N + 1.3) + this.mueff);
        this.cmu = Math.min(1.0 - this.c1, 2.0 * (this.mueff - 2.0 + 1.0 / this.mueff) / ((double)((N + 2) * (N + 2)) + this.mueff));
        this.damps = 1.0 + 2.0 * Math.max(0.0, Math.sqrt((this.mueff - 1.0) / (double)(N + 1)) - 1.0) + this.cs;
        this.diagD = new double[N];
        this.pc = new double[N];
        this.ps = new double[N];
        this.B = new double[N][N];
        this.C = new double[N][N];
        this.invsqrtC = new double[N][N];
        for (i = 0; i < N; ++i) {
            int j;
            this.pc[i] = 0.0;
            this.ps[i] = 0.0;
            this.diagD[i] = 1.0;
            for (j = 0; j < N; ++j) {
                this.B[i][j] = 0.0;
                this.invsqrtC[i][j] = 0.0;
            }
            for (j = 0; j < i; ++j) {
                this.C[i][j] = 0.0;
            }
            this.B[i][i] = 1.0;
            this.C[i][i] = this.diagD[i] * this.diagD[i];
            this.invsqrtC[i][i] = 1.0;
        }
        this.eigeneval = 0;
        this.chiN = Math.sqrt(N) * (double)(1 - 1 / (4 * N) + 1 / (21 * N * N));
        this.xold = new double[N];
        this.arx = new double[lambda][N];
    }

    private SolutionSet samplePopulation() throws JMException, ClassNotFoundException {
        int N = this.problem_.getNumberOfVariables();
        double[] artmp = new double[N];
        for (int iNk = 0; iNk < this.populationSize; ++iNk) {
            int i;
            for (i = 0; i < N; ++i) {
                artmp[i] = this.diagD[i] * this.rand.nextGaussian();
            }
            for (i = 0; i < N; ++i) {
                double sum = 0.0;
                for (int j = 0; j < N; ++j) {
                    sum += this.B[i][j] * artmp[j];
                }
                this.arx[iNk][i] = this.xmean[i] + this.sigma * sum;
            }
        }
        return this.genoPhenoTransformation(this.arx);
    }

    private SolutionSet genoPhenoTransformation(double[][] popx) throws JMException, ClassNotFoundException {
        SolutionSet population_ = new SolutionSet(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            Solution solution = new Solution(this.problem_);
            for (int j = 0; j < this.problem_.getNumberOfVariables(); ++j) {
                solution.getDecisionVariables()[j].setValue(popx[i][j]);
            }
            population_.add(solution);
        }
        return population_;
    }

    private boolean isFeasible(Solution solution) throws JMException {
        boolean res = true;
        Variable[] x = solution.getDecisionVariables();
        for (int i = 0; i < this.problem_.getNumberOfVariables(); ++i) {
            double value = x[i].getValue();
            if (!(value < this.problem_.getLowerLimit(i)) && !(value > this.problem_.getUpperLimit(i))) continue;
            res = false;
        }
        return res;
    }

    private Solution resampleSingle(int iNk) throws JMException, ClassNotFoundException {
        for (int i = 0; i < this.problem_.getNumberOfVariables(); ++i) {
            if (this.arx[iNk][i] > this.problem_.getUpperLimit(i)) {
                this.arx[iNk][i] = this.problem_.getUpperLimit(i);
                continue;
            }
            if (!(this.arx[iNk][i] < this.problem_.getLowerLimit(i))) continue;
            this.arx[iNk][i] = this.problem_.getLowerLimit(i);
        }
        return this.genoPhenoTransformation(this.arx[iNk]);
    }

    private Solution genoPhenoTransformation(double[] x) throws JMException, ClassNotFoundException {
        Solution solution = new Solution(this.problem_);
        for (int i = 0; i < this.problem_.getNumberOfVariables(); ++i) {
            solution.getDecisionVariables()[i].setValue(x[i]);
        }
        return solution;
    }

    private void storeBest(Comparator comparator) {
        Solution bestInPopulation = new Solution(this.population_.best(comparator));
        if (this.bestSolutionEver == null || this.bestSolutionEver.getObjective(0) > bestInPopulation.getObjective(0)) {
            this.bestSolutionEver = bestInPopulation;
        }
    }

    private void updateDistribution() throws JMException {
        int j;
        int i;
        int i2;
        int i3;
        int N = this.problem_.getNumberOfVariables();
        int lambda = this.populationSize;
        double[] arfitness = new double[lambda];
        int[] arindex = new int[lambda];
        for (i3 = 0; i3 < lambda; ++i3) {
            arfitness[i3] = this.population_.get(i3).getObjective(0);
            arindex[i3] = i3;
        }
        Utils.minFastSort(arfitness, arindex, lambda);
        for (i3 = 0; i3 < N; ++i3) {
            this.xold[i3] = this.xmean[i3];
            this.xmean[i3] = 0.0;
            for (int iNk = 0; iNk < this.mu; ++iNk) {
                int n = i3;
                this.xmean[n] = this.xmean[n] + this.weights[iNk] * this.arx[arindex[iNk]][i3];
            }
        }
        double[] artmp = new double[N];
        for (i2 = 0; i2 < N; ++i2) {
            artmp[i2] = 0.0;
            for (int j2 = 0; j2 < N; ++j2) {
                int n = i2;
                artmp[n] = artmp[n] + this.invsqrtC[i2][j2] * (this.xmean[j2] - this.xold[j2]) / this.sigma;
            }
        }
        for (i2 = 0; i2 < N; ++i2) {
            this.ps[i2] = (1.0 - this.cs) * this.ps[i2] + Math.sqrt(this.cs * (2.0 - this.cs) * this.mueff) * artmp[i2];
        }
        double psxps = 0.0;
        for (int i4 = 0; i4 < N; ++i4) {
            psxps += this.ps[i4] * this.ps[i4];
        }
        int hsig = 0;
        if (Math.sqrt(psxps) / Math.sqrt(1.0 - Math.pow(1.0 - this.cs, 2.0 * (double)this.counteval / (double)lambda)) / this.chiN < 1.4 + 2.0 / ((double)N + 1.0)) {
            hsig = 1;
        }
        for (i = 0; i < N; ++i) {
            this.pc[i] = (1.0 - this.cc) * this.pc[i] + (double)hsig * Math.sqrt(this.cc * (2.0 - this.cc) * this.mueff) * (this.xmean[i] - this.xold[i]) / this.sigma;
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j <= i; ++j) {
                this.C[i][j] = (1.0 - this.c1 - this.cmu) * this.C[i][j] + this.c1 * (this.pc[i] * this.pc[j] + (double)(1 - hsig) * this.cc * (2.0 - this.cc) * this.C[i][j]);
                for (int k = 0; k < this.mu; ++k) {
                    double[] dArray = this.C[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.cmu * this.weights[k] * (this.arx[arindex[k]][i] - this.xold[i]) * (this.arx[arindex[k]][j] - this.xold[j]) / this.sigma / this.sigma;
                }
            }
        }
        this.sigma *= Math.exp(this.cs / this.damps * (Math.sqrt(psxps) / this.chiN - 1.0));
        if ((double)(this.counteval - this.eigeneval) > (double)lambda / (this.c1 + this.cmu) / (double)N / 10.0) {
            int j3;
            int i5;
            this.eigeneval = this.counteval;
            for (i = 0; i < N; ++i) {
                for (j = 0; j <= i; ++j) {
                    double d = this.C[i][j];
                    this.B[j][i] = d;
                    this.B[i][j] = d;
                }
            }
            double[] offdiag = new double[N];
            Utils.tred2(N, this.B, this.diagD, offdiag);
            Utils.tql2(N, this.diagD, offdiag, this.B);
            if (Utils.checkEigenSystem(N, this.C, this.diagD, this.B) > 0) {
                this.counteval = this.maxEvaluations;
            }
            for (int i6 = 0; i6 < N; ++i6) {
                if (this.diagD[i6] < 0.0) {
                    System.err.println("jmetal.metaheuristics.cmaes.CMAES.updateDistribution(): WARNING - an eigenvalue has become negative.");
                    this.counteval = this.maxEvaluations;
                }
                this.diagD[i6] = Math.sqrt(this.diagD[i6]);
            }
            double[][] artmp2 = new double[N][N];
            for (i5 = 0; i5 < N; ++i5) {
                for (j3 = 0; j3 < N; ++j3) {
                    artmp2[i5][j3] = this.B[i5][j3] * (1.0 / this.diagD[j3]);
                }
            }
            for (i5 = 0; i5 < N; ++i5) {
                for (j3 = 0; j3 < N; ++j3) {
                    this.invsqrtC[i5][j3] = 0.0;
                    for (int k = 0; k < N; ++k) {
                        double[] dArray = this.invsqrtC[i5];
                        int n = j3;
                        dArray[n] = dArray[n] + artmp2[i5][k] * this.B[j3][k];
                    }
                }
            }
        }
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        this.populationSize = (Integer)this.getInputParameter("populationSize");
        this.maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        this.counteval = 0;
        ObjectiveComparator comparator = new ObjectiveComparator(0);
        this.init();
        while (this.counteval < this.maxEvaluations) {
            this.population_ = this.samplePopulation();
            for (int i = 0; i < this.populationSize; ++i) {
                if (!this.isFeasible(this.population_.get(i))) {
                    this.population_.replace(i, this.resampleSingle(i));
                }
                this.problem_.evaluate(this.population_.get(i));
                this.counteval += this.populationSize;
            }
            this.storeBest(comparator);
            System.out.println(this.counteval + ": " + this.bestSolutionEver);
            this.updateDistribution();
        }
        SolutionSet resultPopulation = new SolutionSet(1);
        resultPopulation.add(this.bestSolutionEver);
        return resultPopulation;
    }
}

