/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.cmaes;

public class Utils {
    public static void tred2(int n, double[][] V, double[] d, double[] e) {
        int i;
        int j;
        for (j = 0; j < n; ++j) {
            d[j] = V[n - 1][j];
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    d[j2] = V[i - 1][j2];
                    V[i][j2] = 0.0;
                    V[j2][i] = 0.0;
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                for (j4 = 0; j4 < i; ++j4) {
                    e[j4] = 0.0;
                }
                for (j4 = 0; j4 < i; ++j4) {
                    V[j4][i] = f = d[j4];
                    g = e[j4] + V[j4][j4] * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g += V[k2][j4] * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + V[k2][j4] * f;
                    }
                    e[j4] = g;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n4 = j4;
                    e[n4] = e[n4] / h;
                    f += e[j4] * d[j4];
                }
                double hh = f / (h + h);
                for (j3 = 0; j3 < i; ++j3) {
                    int n5 = j3;
                    e[n5] = e[n5] - hh * d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = d[j3];
                    g = e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        double[] dArray = V[k3];
                        int n6 = j3;
                        dArray[n6] = dArray[n6] - (f * e[k3] + g * d[k3]);
                    }
                    d[j3] = V[i - 1][j3];
                    V[i][j3] = 0.0;
                }
            }
            d[i] = h;
        }
        for (i = 0; i < n - 1; ++i) {
            int k;
            V[n - 1][i] = V[i][i];
            V[i][i] = 1.0;
            double h = d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    d[k] = V[k][i + 1] / h;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += V[k4][i + 1] * V[k4][j5];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = V[k4];
                        int n7 = j5;
                        dArray[n7] = dArray[n7] - g * d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                V[k][i + 1] = 0.0;
            }
        }
        for (j = 0; j < n; ++j) {
            d[j] = V[n - 1][j];
            V[n - 1][j] = 0.0;
        }
        V[n - 1][n - 1] = 1.0;
        e[0] = 0.0;
    }

    public static void tql2(int n, double[] d, double[] e, double[][] V) {
        for (int i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            for (m = l; m < n && !(Math.abs(e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = d[l];
                    double p = (d[l + 1] - g) / (2.0 * e[l]);
                    double r = Utils.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    d[l] = e[l] / (p + r);
                    d[l + 1] = e[l] * (p + r);
                    double dl1 = d[l + 1];
                    double h = g - d[l];
                    int i = l + 2;
                    while (i < n) {
                        int n2 = i++;
                        d[n2] = d[n2] - h;
                    }
                    f += h;
                    p = d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * e[i2];
                        h = c * p;
                        r = Utils.hypot(p, e[i2]);
                        e[i2 + 1] = s * r;
                        s = e[i2] / r;
                        c = p / r;
                        p = c * d[i2] - s * g;
                        d[i2 + 1] = h + s * (c * g + s * d[i2]);
                        for (int k = 0; k < n; ++k) {
                            h = V[k][i2 + 1];
                            V[k][i2 + 1] = s * V[k][i2] + c * h;
                            V[k][i2] = c * V[k][i2] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * e[l] / dl1;
                    e[l] = s * p;
                    d[l] = c * p;
                } while (Math.abs(e[l]) > eps * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
        }
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = d[i];
            for (j = i + 1; j < n; ++j) {
                if (!(d[j] < p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            for (j = 0; j < n; ++j) {
                p = V[j][i];
                V[j][i] = V[j][k];
                V[j][k] = p;
            }
        }
    }

    public static int checkEigenSystem(int N, double[][] C, double[] diag, double[][] Q) {
        int res = 0;
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                String s;
                double cc = 0.0;
                double dd = 0.0;
                for (int k = 0; k < N; ++k) {
                    cc += diag[k] * Q[i][k] * Q[j][k];
                    dd += Q[i][k] * Q[j][k];
                }
                double[] dArray = C[i > j ? i : j];
                int n = i > j ? j : i;
                if (Math.abs(cc - dArray[n]) / Math.sqrt(C[i][i] * C[j][j]) > 1.0E-10) {
                    double[] dArray2 = C[i > j ? i : j];
                    int n2 = i > j ? j : i;
                    if (Math.abs(cc - dArray2[n2]) > 1.0E-9) {
                        s = " " + i + " " + j + " " + cc + " " + C[i > j ? i : j][i > j ? j : i] + " " + (cc - C[i > j ? i : j][i > j ? j : i]);
                        System.err.println("jmetal.metaheuristics.cmaes.Utils.checkEigenSystem(): WARNING - imprecise result detected " + s);
                        ++res;
                    }
                }
                boolean bl = i == j;
                if (!(Math.abs(dd - (double)bl) > 1.0E-10)) continue;
                s = i + " " + j + " " + dd;
                System.err.println("jmetal.metaheuristics.cmaes.Utils.checkEigenSystem(): WARNING - imprecise result detected (Q not orthog.) " + s);
                ++res;
            }
        }
        return res;
    }

    private static double hypot(double a, double b) {
        double r = 0.0;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        }
        return r;
    }

    public static void minFastSort(double[] x, int[] idx, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                int tempIdx;
                double temp;
                if (x[i] > x[j]) {
                    temp = x[i];
                    tempIdx = idx[i];
                    x[i] = x[j];
                    x[j] = temp;
                    idx[i] = idx[j];
                    idx[j] = tempIdx;
                    continue;
                }
                if (x[i] != x[j] || idx[i] <= idx[j]) continue;
                temp = x[i];
                tempIdx = idx[i];
                x[i] = x[j];
                x[j] = temp;
                idx[i] = idx[j];
                idx[j] = tempIdx;
            }
        }
    }
}

