/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.differentialEvolution;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.JMException;
import jmetal.util.comparators.ObjectiveComparator;

public class DE
extends Algorithm {
    public DE(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        ObjectiveComparator comparator = new ObjectiveComparator(0);
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        SolutionSet population = new SolutionSet(populationSize);
        int evaluations = 0;
        for (i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            this.problem_.evaluateConstraints(newSolution);
            ++evaluations;
            population.add(newSolution);
        }
        population.sort(comparator);
        while (evaluations < maxEvaluations) {
            SolutionSet offspringPopulation = new SolutionSet(populationSize);
            for (i = 0; i < populationSize; ++i) {
                Solution[] parent = (Solution[])selectionOperator.execute(new Object[]{population, i});
                Solution child = (Solution)crossoverOperator.execute(new Object[]{population.get(i), parent});
                this.problem_.evaluate(child);
                ++evaluations;
                if (comparator.compare(population.get(i), child) < 0) {
                    offspringPopulation.add(new Solution(population.get(i)));
                    continue;
                }
                offspringPopulation.add(child);
            }
            population.clear();
            for (i = 0; i < populationSize; ++i) {
                population.add(offspringPopulation.get(i));
            }
            offspringPopulation.clear();
            population.sort(comparator);
        }
        SolutionSet resultPopulation = new SolutionSet(1);
        resultPopulation.add(population.get(0));
        System.out.println("Evaluations: " + evaluations);
        return resultPopulation;
    }
}

