/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.differentialEvolution;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.singleObjective.differentialEvolution.DE;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.singleObjective.Sphere;
import jmetal.util.JMException;

public class DE_main {
    public static void main(String[] args) throws JMException, ClassNotFoundException {
        Sphere problem = new Sphere("Real", 20);
        DE algorithm = new DE(problem);
        algorithm.setInputParameter("populationSize", 100);
        algorithm.setInputParameter("maxEvaluations", 1000000);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("CR", 0.5);
        parameters.put("F", 0.5);
        parameters.put("DE_VARIANT", "rand/1/bin");
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("DifferentialEvolutionSelection", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("selection", selection);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        System.out.println("Total execution time: " + estimatedTime);
        System.out.println("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        System.out.println("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
    }
}

