/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.evolutionStrategy;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.JMException;
import jmetal.util.comparators.ObjectiveComparator;

public class ElitistES
extends Algorithm {
    private int mu_;
    private int lambda_;

    public ElitistES(Problem problem, int mu, int lambda) {
        super(problem);
        this.mu_ = mu;
        this.lambda_ = lambda;
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        ObjectiveComparator comparator = new ObjectiveComparator(0);
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        SolutionSet population = new SolutionSet(this.mu_);
        SolutionSet offspringPopulation = new SolutionSet(this.mu_ + this.lambda_);
        int evaluations = 0;
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        System.out.println("(" + this.mu_ + " + " + this.lambda_ + ")ES");
        for (int i = 0; i < this.mu_; ++i) {
            Solution newIndividual = new Solution(this.problem_);
            this.problem_.evaluate(newIndividual);
            ++evaluations;
            population.add(newIndividual);
        }
        int offsprings = this.lambda_ / this.mu_;
        while (evaluations < maxEvaluations) {
            int i;
            for (i = 0; i < this.mu_; ++i) {
                for (int j = 0; j < offsprings; ++j) {
                    Solution offspring = new Solution(population.get(i));
                    mutationOperator.execute(offspring);
                    this.problem_.evaluate(offspring);
                    offspringPopulation.add(offspring);
                    ++evaluations;
                }
            }
            for (i = 0; i < this.mu_; ++i) {
                offspringPopulation.add(population.get(i));
            }
            population.clear();
            offspringPopulation.sort(comparator);
            for (i = 0; i < this.mu_; ++i) {
                population.add(offspringPopulation.get(i));
            }
            System.out.println("Evaluation: " + evaluations + " Fitness: " + population.get(0).getObjective(0));
            offspringPopulation.clear();
        }
        SolutionSet resultPopulation = new SolutionSet(1);
        resultPopulation.add(population.get(0));
        return resultPopulation;
    }
}

