/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.geneticAlgorithm;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.JMException;
import jmetal.util.comparators.ObjectiveComparator;

public class gGA
extends Algorithm {
    public gGA(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        ObjectiveComparator comparator = new ObjectiveComparator(0);
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        SolutionSet population = new SolutionSet(populationSize);
        SolutionSet offspringPopulation = new SolutionSet(populationSize);
        int evaluations = 0;
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        for (i = 0; i < populationSize; ++i) {
            Solution newIndividual = new Solution(this.problem_);
            this.problem_.evaluate(newIndividual);
            ++evaluations;
            population.add(newIndividual);
        }
        population.sort(comparator);
        while (evaluations < maxEvaluations) {
            if (evaluations % 10 == 0) {
                System.out.println(evaluations + ": " + population.get(0).getObjective(0));
            }
            offspringPopulation.add(new Solution(population.get(0)));
            offspringPopulation.add(new Solution(population.get(1)));
            for (i = 0; i < populationSize / 2 - 1; ++i) {
                Solution[] parents = new Solution[]{(Solution)selectionOperator.execute(population), (Solution)selectionOperator.execute(population)};
                Solution[] offspring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offspring[0]);
                mutationOperator.execute(offspring[1]);
                this.problem_.evaluate(offspring[0]);
                this.problem_.evaluate(offspring[1]);
                evaluations += 2;
                offspringPopulation.add(offspring[0]);
                offspringPopulation.add(offspring[1]);
            }
            population.clear();
            for (i = 0; i < populationSize; ++i) {
                population.add(offspringPopulation.get(i));
            }
            offspringPopulation.clear();
            population.sort(comparator);
        }
        SolutionSet resultPopulation = new SolutionSet(1);
        resultPopulation.add(population.get(0));
        System.out.println("Evaluations: " + evaluations);
        return resultPopulation;
    }
}

