/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.geneticAlgorithm;

import java.util.List;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.JMException;
import jmetal.util.comparators.ObjectiveComparator;
import jmetal.util.parallel.IParallelEvaluator;

public class pgGA
extends Algorithm {
    IParallelEvaluator parallelEvaluator_;

    public pgGA(Problem problem, IParallelEvaluator evaluator) {
        super(problem);
        this.parallelEvaluator_ = evaluator;
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        ObjectiveComparator comparator = new ObjectiveComparator(0);
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        this.parallelEvaluator_.startEvaluator(this.problem_);
        SolutionSet population = new SolutionSet(populationSize);
        SolutionSet offspringPopulation = new SolutionSet(populationSize);
        int evaluations = 0;
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        for (int i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.parallelEvaluator_.addSolutionForEvaluation(newSolution);
        }
        List<Solution> solutionList = this.parallelEvaluator_.parallelEvaluation();
        for (Solution solution : solutionList) {
            population.add(solution);
            ++evaluations;
        }
        population.sort(comparator);
        while (evaluations < maxEvaluations) {
            offspringPopulation.add(new Solution(population.get(0)));
            offspringPopulation.add(new Solution(population.get(1)));
            Solution[] parents = new Solution[2];
            for (int i = 0; i < populationSize / 2 - 1; ++i) {
                if (evaluations >= maxEvaluations) continue;
                parents[0] = (Solution)selectionOperator.execute(population);
                parents[1] = (Solution)selectionOperator.execute(population);
                Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offSpring[0]);
                mutationOperator.execute(offSpring[1]);
                this.parallelEvaluator_.addSolutionForEvaluation(offSpring[0]);
                this.parallelEvaluator_.addSolutionForEvaluation(offSpring[1]);
            }
            List<Solution> solutions = this.parallelEvaluator_.parallelEvaluation();
            for (Solution solution : solutions) {
                offspringPopulation.add(solution);
                ++evaluations;
            }
            population.clear();
            for (int i = 0; i < populationSize; ++i) {
                population.add(offspringPopulation.get(i));
            }
            offspringPopulation.clear();
            population.sort(comparator);
        }
        this.parallelEvaluator_.stopEvaluator();
        SolutionSet resultPopulation = new SolutionSet(1);
        resultPopulation.add(population.get(0));
        System.out.println("Evaluations: " + evaluations);
        return resultPopulation;
    }
}

