/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.geneticAlgorithm;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.singleObjective.geneticAlgorithm.pgGA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.singleObjective.Griewank;
import jmetal.util.JMException;
import jmetal.util.parallel.MultithreadedEvaluator;

public class pgGA_main {
    public static void main(String[] args) throws JMException, ClassNotFoundException {
        int threads = 4;
        MultithreadedEvaluator parallelEvaluator = new MultithreadedEvaluator(threads);
        Griewank problem = new Griewank("Real", 10);
        pgGA algorithm = new pgGA(problem, parallelEvaluator);
        algorithm.setInputParameter("populationSize", 100);
        algorithm.setInputParameter("maxEvaluations", 2500000);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", 0.9);
        parameters.put("distributionIndex", 20.0);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 1.0 / (double)problem.getNumberOfVariables());
        parameters.put("distributionIndex", 20.0);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        System.out.println("Total execution time: " + estimatedTime);
        System.out.println("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        System.out.println("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
    }
}

