/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.smpso;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.Hypervolume;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.qualityIndicator.fastHypervolume.FastHypervolumeArchive;
import jmetal.qualityIndicator.util.MetricsUtil;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.comparators.CrowdingDistanceComparator;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.wrapper.XReal;

public class SMPSOhv
extends Algorithm {
    private int swarmSize_;
    private int archiveSize_;
    private int maxIterations_;
    private int iteration_;
    private SolutionSet particles_;
    private Solution[] best_;
    private FastHypervolumeArchive leaders_;
    private double[][] speed_;
    private Comparator dominance_;
    private Comparator crowdingDistanceComparator_;
    private Distance distance_;
    private Operator polynomialMutation_;
    QualityIndicator indicators_;
    double r1Max_;
    double r1Min_;
    double r2Max_;
    double r2Min_;
    double C1Max_;
    double C1Min_;
    double C2Max_;
    double C2Min_;
    double WMax_;
    double WMin_;
    double ChVel1_;
    double ChVel2_;
    private double trueHypervolume_;
    private Hypervolume hy_;
    private SolutionSet trueFront_;
    private double[] deltaMax_;
    private double[] deltaMin_;
    boolean success_;

    public SMPSOhv(Problem problem) {
        super(problem);
        this.r1Max_ = 1.0;
        this.r1Min_ = 0.0;
        this.r2Max_ = 1.0;
        this.r2Min_ = 0.0;
        this.C1Max_ = 2.5;
        this.C1Min_ = 1.5;
        this.C2Max_ = 2.5;
        this.C2Min_ = 1.5;
        this.WMax_ = 0.1;
        this.WMin_ = 0.1;
        this.ChVel1_ = -1.0;
        this.ChVel2_ = -1.0;
    }

    public SMPSOhv(Problem problem, Vector<Double> variables, String trueParetoFront) throws FileNotFoundException {
        super(problem);
        this.r1Max_ = variables.get(0);
        this.r1Min_ = variables.get(1);
        this.r2Max_ = variables.get(2);
        this.r2Min_ = variables.get(3);
        this.C1Max_ = variables.get(4);
        this.C1Min_ = variables.get(5);
        this.C2Max_ = variables.get(6);
        this.C2Min_ = variables.get(7);
        this.WMax_ = variables.get(8);
        this.WMin_ = variables.get(9);
        this.ChVel1_ = variables.get(10);
        this.ChVel2_ = variables.get(11);
        this.hy_ = new Hypervolume();
        MetricsUtil mu = new MetricsUtil();
        this.trueFront_ = mu.readNonDominatedSolutionSet(trueParetoFront);
        this.trueHypervolume_ = this.hy_.hypervolume(this.trueFront_.writeObjectivesToMatrix(), this.trueFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
    }

    public SMPSOhv(Problem problem, String trueParetoFront) throws FileNotFoundException {
        super(problem);
        this.hy_ = new Hypervolume();
        MetricsUtil mu = new MetricsUtil();
        this.trueFront_ = mu.readNonDominatedSolutionSet(trueParetoFront);
        this.trueHypervolume_ = this.hy_.hypervolume(this.trueFront_.writeObjectivesToMatrix(), this.trueFront_.writeObjectivesToMatrix(), this.problem_.getNumberOfObjectives());
        this.r1Max_ = 1.0;
        this.r1Min_ = 0.0;
        this.r2Max_ = 1.0;
        this.r2Min_ = 0.0;
        this.C1Max_ = 2.5;
        this.C1Min_ = 1.5;
        this.C2Max_ = 2.5;
        this.C2Min_ = 1.5;
        this.WMax_ = 0.1;
        this.WMin_ = 0.1;
        this.ChVel1_ = -1.0;
        this.ChVel2_ = -1.0;
    }

    public void initParams() {
        this.swarmSize_ = (Integer)this.getInputParameter("swarmSize");
        this.archiveSize_ = (Integer)this.getInputParameter("archiveSize");
        this.maxIterations_ = (Integer)this.getInputParameter("maxIterations");
        this.indicators_ = (QualityIndicator)this.getInputParameter("indicators");
        this.polynomialMutation_ = (Operator)this.operators_.get("mutation");
        this.iteration_ = 0;
        this.success_ = false;
        this.particles_ = new SolutionSet(this.swarmSize_);
        this.best_ = new Solution[this.swarmSize_];
        this.leaders_ = new FastHypervolumeArchive(this.archiveSize_, this.problem_.getNumberOfObjectives());
        this.dominance_ = new DominanceComparator();
        this.crowdingDistanceComparator_ = new CrowdingDistanceComparator();
        this.distance_ = new Distance();
        this.speed_ = new double[this.swarmSize_][this.problem_.getNumberOfVariables()];
        this.deltaMax_ = new double[this.problem_.getNumberOfVariables()];
        this.deltaMin_ = new double[this.problem_.getNumberOfVariables()];
        for (int i = 0; i < this.problem_.getNumberOfVariables(); ++i) {
            this.deltaMax_[i] = (this.problem_.getUpperLimit(i) - this.problem_.getLowerLimit(i)) / 2.0;
            this.deltaMin_[i] = -this.deltaMax_[i];
        }
    }

    private double inertiaWeight(int iter, int miter, double wma, double wmin) {
        return wma;
    }

    private double constrictionCoefficient(double c1, double c2) {
        double rho = c1 + c2;
        if (rho <= 4.0) {
            return 1.0;
        }
        return 2.0 / (2.0 - rho - Math.sqrt(Math.pow(rho, 2.0) - 4.0 * rho));
    }

    private double velocityConstriction(double v, double[] deltaMax, double[] deltaMin, int variableIndex, int particleIndex) throws IOException {
        double dmax = deltaMax[variableIndex];
        double dmin = deltaMin[variableIndex];
        double result = v;
        if (v > dmax) {
            result = dmax;
        }
        if (v < dmin) {
            result = dmin;
        }
        return result;
    }

    private void computeSpeed(int iter, int miter) throws JMException, IOException {
        for (int i = 0; i < this.swarmSize_; ++i) {
            Solution two;
            XReal particle = new XReal(this.particles_.get(i));
            XReal bestParticle = new XReal(this.best_[i]);
            int pos1 = PseudoRandom.randInt(0, this.leaders_.size() - 1);
            int pos2 = PseudoRandom.randInt(0, this.leaders_.size() - 1);
            Solution one = this.leaders_.get(pos1);
            XReal bestGlobal = this.crowdingDistanceComparator_.compare(one, two = this.leaders_.get(pos2)) < 1 ? new XReal(one) : new XReal(two);
            double r1 = PseudoRandom.randDouble(this.r1Min_, this.r1Max_);
            double r2 = PseudoRandom.randDouble(this.r2Min_, this.r2Max_);
            double C1 = PseudoRandom.randDouble(this.C1Min_, this.C1Max_);
            double C2 = PseudoRandom.randDouble(this.C2Min_, this.C2Max_);
            double W = PseudoRandom.randDouble(this.WMin_, this.WMax_);
            double wmax = this.WMax_;
            double wmin = this.WMin_;
            for (int var = 0; var < particle.getNumberOfDecisionVariables(); ++var) {
                this.speed_[i][var] = this.velocityConstriction(this.constrictionCoefficient(C1, C2) * (this.inertiaWeight(iter, miter, wmax, wmin) * this.speed_[i][var] + C1 * r1 * (bestParticle.getValue(var) - particle.getValue(var)) + C2 * r2 * (bestGlobal.getValue(var) - particle.getValue(var))), this.deltaMax_, this.deltaMin_, var, i);
            }
        }
    }

    private void computeNewPositions() throws JMException {
        for (int i = 0; i < this.swarmSize_; ++i) {
            XReal particle = new XReal(this.particles_.get(i));
            for (int var = 0; var < particle.getNumberOfDecisionVariables(); ++var) {
                particle.setValue(var, particle.getValue(var) + this.speed_[i][var]);
                if (particle.getValue(var) < this.problem_.getLowerLimit(var)) {
                    particle.setValue(var, this.problem_.getLowerLimit(var));
                    this.speed_[i][var] = this.speed_[i][var] * this.ChVel1_;
                }
                if (!(particle.getValue(var) > this.problem_.getUpperLimit(var))) continue;
                particle.setValue(var, this.problem_.getUpperLimit(var));
                this.speed_[i][var] = this.speed_[i][var] * this.ChVel2_;
            }
        }
    }

    private void mopsoMutation(int actualIteration, int totalIterations) throws JMException {
        for (int i = 0; i < this.particles_.size(); ++i) {
            if (i % 6 != 0) continue;
            this.polynomialMutation_.execute(this.particles_.get(i));
        }
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        this.initParams();
        this.success_ = false;
        for (i = 0; i < this.swarmSize_; ++i) {
            Solution particle = new Solution(this.problem_);
            this.problem_.evaluate(particle);
            this.problem_.evaluateConstraints(particle);
            this.particles_.add(particle);
        }
        for (i = 0; i < this.swarmSize_; ++i) {
            for (int j = 0; j < this.problem_.getNumberOfVariables(); ++j) {
                this.speed_[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.particles_.size(); ++i) {
            Solution particle = new Solution(this.particles_.get(i));
            this.leaders_.add(particle);
        }
        for (i = 0; i < this.particles_.size(); ++i) {
            Solution particle;
            this.best_[i] = particle = new Solution(this.particles_.get(i));
        }
        this.leaders_.computeHVContribution();
        while (this.iteration_ < this.maxIterations_) {
            System.out.println("Iteration: " + this.iteration_ + " times");
            try {
                this.computeSpeed(this.iteration_, this.maxIterations_);
            }
            catch (IOException ex) {
                Logger.getLogger(SMPSOhv.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.computeNewPositions();
            this.mopsoMutation(this.iteration_, this.maxIterations_);
            for (i = 0; i < this.particles_.size(); ++i) {
                Solution particle = this.particles_.get(i);
                this.problem_.evaluate(particle);
                this.problem_.evaluateConstraints(particle);
            }
            for (i = 0; i < this.particles_.size(); ++i) {
                Solution particle = new Solution(this.particles_.get(i));
                this.leaders_.add(particle);
            }
            if (this.leaders_.size() < this.archiveSize_) {
                this.leaders_.computeHVContribution();
            }
            for (i = 0; i < this.particles_.size(); ++i) {
                Solution particle;
                int flag = this.dominance_.compare(this.particles_.get(i), this.best_[i]);
                if (flag == 1) continue;
                this.best_[i] = particle = new Solution(this.particles_.get(i));
            }
            ++this.iteration_;
        }
        return this.leaders_;
    }

    public SolutionSet getLeader() {
        return this.leaders_;
    }
}

