/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.smsemoa;

import java.util.Collections;
import java.util.LinkedList;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.Hypervolume;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.qualityIndicator.fastHypervolume.FastHypervolume;
import jmetal.qualityIndicator.util.MetricsUtil;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.CrowdingDistanceComparator;

public class FastSMSEMOA
extends Algorithm {
    private MetricsUtil utils_ = new MetricsUtil();
    private Hypervolume hv_ = new Hypervolume();

    public FastSMSEMOA(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        QualityIndicator indicators = (QualityIndicator)this.getInputParameter("indicators");
        double offset = (Double)this.getInputParameter("offset");
        SolutionSet population = new SolutionSet(populationSize);
        int evaluations = 0;
        int requiredEvaluations = 0;
        FastHypervolume fastHypervolume = new FastHypervolume(offset);
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        for (int i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            this.problem_.evaluateConstraints(newSolution);
            ++evaluations;
            population.add(newSolution);
        }
        while (evaluations < maxEvaluations) {
            double HV;
            int i;
            SolutionSet offspringPopulation = new SolutionSet(populationSize);
            LinkedList<Solution> selectedParents = new LinkedList<Solution>();
            Solution[] parents = new Solution[]{};
            while (selectedParents.size() < 2) {
                Object selected = selectionOperator.execute(population);
                try {
                    Solution parent = (Solution)selected;
                    selectedParents.add(parent);
                }
                catch (ClassCastException e) {
                    parents = (Solution[])selected;
                    Collections.addAll(selectedParents, parents);
                }
            }
            parents = selectedParents.toArray(parents);
            Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
            mutationOperator.execute(offSpring[0]);
            this.problem_.evaluate(offSpring[0]);
            this.problem_.evaluateConstraints(offSpring[0]);
            offspringPopulation.add(offSpring[0]);
            ++evaluations;
            SolutionSet union = population.union(offspringPopulation);
            Ranking ranking = new Ranking(union);
            for (int j = 0; j < population.size(); ++j) {
                population.get(j).setCrowdingDistance(0.0);
            }
            SolutionSet lastFront = ranking.getSubfront(ranking.getNumberOfSubfronts() - 1);
            fastHypervolume.computeHVContributions(lastFront);
            lastFront.sort(new CrowdingDistanceComparator());
            SolutionSet front = null;
            population.clear();
            for (i = 0; i < ranking.getNumberOfSubfronts() - 1; ++i) {
                front = ranking.getSubfront(i);
                for (int j = 0; j < front.size(); ++j) {
                    population.add(front.get(j));
                }
            }
            for (i = 0; i < lastFront.size() - 1; ++i) {
                population.add(lastFront.get(i));
            }
            if (indicators == null || requiredEvaluations != 0 || !((HV = indicators.getHypervolume(population)) >= 0.98 * indicators.getTrueParetoFrontHypervolume())) continue;
            requiredEvaluations = evaluations;
        }
        this.setOutputParameter("evaluations", requiredEvaluations);
        Ranking ranking = new Ranking(population);
        ranking.getSubfront(0).printFeasibleFUN("FUN");
        return ranking.getSubfront(0);
    }
}

