/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.smsemoa;

import java.util.Collections;
import java.util.LinkedList;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.qualityIndicator.Hypervolume;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.qualityIndicator.util.MetricsUtil;
import jmetal.util.JMException;
import jmetal.util.Ranking;
import jmetal.util.comparators.CrowdingDistanceComparator;

public class SMSEMOA
extends Algorithm {
    private MetricsUtil utils_ = new MetricsUtil();
    private Hypervolume hv_ = new Hypervolume();

    public SMSEMOA(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        double offset = 100.0;
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        QualityIndicator indicators = (QualityIndicator)this.getInputParameter("indicators");
        offset = (Double)this.getInputParameter("offset");
        SolutionSet population = new SolutionSet(populationSize);
        int evaluations = 0;
        int requiredEvaluations = 0;
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        for (int i = 0; i < populationSize; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            this.problem_.evaluateConstraints(newSolution);
            ++evaluations;
            population.add(newSolution);
        }
        while (evaluations < maxEvaluations) {
            double HV;
            int i;
            SolutionSet offspringPopulation = new SolutionSet(populationSize);
            LinkedList<Solution> selectedParents = new LinkedList<Solution>();
            Solution[] parents = new Solution[]{};
            while (selectedParents.size() < 2) {
                Object selected = selectionOperator.execute(population);
                try {
                    Solution parent = (Solution)selected;
                    selectedParents.add(parent);
                }
                catch (ClassCastException e) {
                    parents = (Solution[])selected;
                    Collections.addAll(selectedParents, parents);
                }
            }
            parents = selectedParents.toArray(parents);
            Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
            mutationOperator.execute(offSpring[0]);
            this.problem_.evaluate(offSpring[0]);
            this.problem_.evaluateConstraints(offSpring[0]);
            offspringPopulation.add(offSpring[0]);
            ++evaluations;
            SolutionSet union = population.union(offspringPopulation);
            Ranking ranking = new Ranking(union);
            for (int j = 0; j < population.size(); ++j) {
                population.get(j).setCrowdingDistance(0.0);
            }
            SolutionSet lastFront = ranking.getSubfront(ranking.getNumberOfSubfronts() - 1);
            if (lastFront.size() > 1) {
                double[][] invertedFront;
                double[][] frontValues = lastFront.writeObjectivesToMatrix();
                int numberOfObjectives = this.problem_.getNumberOfObjectives();
                double[] maximumValues = this.utils_.getMaximumValues(union.writeObjectivesToMatrix(), numberOfObjectives);
                double[] minimumValues = this.utils_.getMinimumValues(union.writeObjectivesToMatrix(), numberOfObjectives);
                double[][] normalizedFront = this.utils_.getNormalizedFront(frontValues, maximumValues, minimumValues);
                double[] offsets = new double[maximumValues.length];
                for (int i2 = 0; i2 < maximumValues.length; ++i2) {
                    offsets[i2] = offset / (maximumValues[i2] - minimumValues[i2]);
                }
                for (double[] point : invertedFront = this.utils_.invertedFront(normalizedFront)) {
                    for (int i3 = 0; i3 < point.length; ++i3) {
                        int n = i3;
                        point[n] = point[n] + offsets[i3];
                    }
                }
                double[] contributions = this.hvContributions(invertedFront);
                for (int i4 = 0; i4 < contributions.length; ++i4) {
                    lastFront.get(i4).setCrowdingDistance(contributions[i4]);
                }
                lastFront.sort(new CrowdingDistanceComparator());
            }
            SolutionSet front = null;
            population.clear();
            for (i = 0; i < ranking.getNumberOfSubfronts() - 1; ++i) {
                front = ranking.getSubfront(i);
                for (int j = 0; j < front.size(); ++j) {
                    population.add(front.get(j));
                }
            }
            for (i = 0; i < lastFront.size() - 1; ++i) {
                population.add(lastFront.get(i));
            }
            if (indicators == null || requiredEvaluations != 0 || !((HV = indicators.getHypervolume(population)) >= 0.98 * indicators.getTrueParetoFrontHypervolume())) continue;
            requiredEvaluations = evaluations;
        }
        this.setOutputParameter("evaluations", requiredEvaluations);
        Ranking ranking = new Ranking(population);
        ranking.getSubfront(0).printFeasibleFUN("FUN");
        return ranking.getSubfront(0);
    }

    private double[] hvContributions(double[][] front) {
        int numberOfObjectives = this.problem_.getNumberOfObjectives();
        double[] contributions = new double[front.length];
        double[][] frontSubset = new double[front.length - 1][front[0].length];
        LinkedList<double[]> frontCopy = new LinkedList<double[]>();
        Collections.addAll(frontCopy, front);
        double[][] totalFront = (double[][])frontCopy.toArray((T[])frontSubset);
        double totalVolume = this.hv_.calculateHypervolume(totalFront, totalFront.length, numberOfObjectives);
        for (int i = 0; i < front.length; ++i) {
            double contribution;
            double[] evaluatedPoint = (double[])frontCopy.remove(i);
            frontSubset = (double[][])frontCopy.toArray((T[])frontSubset);
            double hv = this.hv_.calculateHypervolume(frontSubset, frontSubset.length, numberOfObjectives);
            contributions[i] = contribution = totalVolume - hv;
            frontCopy.add(i, evaluatedPoint);
        }
        return contributions;
    }
}

